/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.util.Arrays;

public class LChar
extends LDataType<String> {
    public static final LChar INSTANCE = new LChar();
    public static final byte BLANK_BYTE = 32;
    public static final byte BLANK_BYTE_DESC = DataTypeUtils.invert((byte)32);

    private LChar() {
        super(DataType.CHAR, String.class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LChar#getByteSize(Object) instead.");
    }

    @Override
    public int getByteSize(Object obj) {
        String value = (String)obj;
        return value == null ? 0 : value.length();
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE || targetType == LString.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = Bytes.toBytes((String)value);
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(ret, 0, ret, 0, ret.length);
        }
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        if (actualType == INSTANCE || actualType == LString.INSTANCE) {
            return value;
        }
        throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        if (sortOrder == SortOrder.DESC) {
            byte[] copy = new byte[length];
            DataTypeUtils.invert(value, offset, copy, 0, length);
            return Bytes.toString(copy);
        }
        return Bytes.toString(value, offset, length);
    }

    @Override
    public byte[] pad(byte[] value, int maxLength, SortOrder sortOrder) {
        if (value == null || value.length >= maxLength) {
            return value;
        }
        byte[] ret = new byte[maxLength];
        System.arraycopy(value, 0, ret, 0, value.length);
        if (sortOrder == SortOrder.ASC) {
            Arrays.fill(ret, value.length, maxLength, (byte)32);
        } else {
            Arrays.fill(ret, value.length, maxLength, BLANK_BYTE_DESC);
        }
        return ret;
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_STRING_ARRAY;
    }

    @Override
    public String randomData(DataGenerator dataGenerator) {
        return LString.INSTANCE.randomData(dataGenerator);
    }
}

