/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.LindormTableService;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.search.SearchQuery;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.HintInfo;
import com.alibaba.lindorm.client.core.tableservice.LQueryResults;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.Hint;
import com.alibaba.lindorm.client.dml.OrderedColumnKey;
import com.alibaba.lindorm.client.dml.PagingContext;
import com.alibaba.lindorm.client.dml.QueryResults;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.dml.Select;
import com.alibaba.lindorm.client.exception.DoNotRetryIOException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exception.TableNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LSelect
extends DmlOperation
implements Select {
    private static final Log LOG = LogFactory.getLog(LSelect.class);
    public static final String EXPLAIN_ATTR = "EXPLAIN";
    public static final String HINT_ATTR = "HINT";
    public static final String BATCH_ATTR = "BATCH";
    public static final String BATCHSIZE_ATTR = "BATCHSIZE";
    public static final String FAMILY_ATTR = "FAMILY";
    public static final String ORDER_BY_ATTR = "ORDER_BY";
    public static final String ALLOW_FILTERING_ATTR = "ALLOW_FILTERING";
    public static final String SEARCH_QUERY_ATTR = "SEARCH";
    public static final int NO_LIMIT = -1;
    public static short INVALID_SUBPLAN_INDEX = (short)-1;
    public static final int MAX_SELECT_COLUMNS_COUNT = 10;
    private List<ColumnKey> columns = Collections.emptyList();
    private Condition where;
    private long minStamp = 0L;
    private long maxStamp = Long.MAX_VALUE;
    private int offset = 0;
    private int limit = -1;
    private int batchCount = -1;
    private int batchSize = -1;
    private Boolean supportEmptyResult = true;
    private int maxVersions = 1;
    private boolean isExplain = false;
    private HintInfo hint = null;
    private List<byte[]> families = null;
    private List<OrderedColumnKey> orderByColumns = Collections.emptyList();
    private Boolean allowFiltering = null;
    private LQueryResults.SelectContext context;
    private boolean isPagingContextSet = false;
    private boolean isDigestQuery = false;
    private boolean isSearchIndexQuery = false;
    private SearchQuery searchQuery;

    public LSelect() {
    }

    public LSelect(LindormTableService service) {
        super(service);
    }

    @Override
    public Select columns(String ... columns) {
        this.columns = CollectionUtils.newArrayListWithCapacity(columns.length);
        for (String col : columns) {
            this.columns.add(new ColumnKey(Bytes.toBytes(col)));
        }
        return this;
    }

    @Override
    public Select columns(byte[] ... columns) {
        this.columns = CollectionUtils.newArrayListWithCapacity(columns.length);
        for (byte[] col : columns) {
            this.columns.add(new ColumnKey(col));
        }
        return this;
    }

    @Override
    public Select columns(List<ColumnKey> columns) {
        this.columns = columns;
        return this;
    }

    @Override
    public Select setNamespace(String namespace) {
        super.setNamespaceInternal(namespace);
        return this;
    }

    @Override
    public Select from(String tableName) throws LindormException {
        if (this.service != null) {
            this.namespace = this.service.getNamespace();
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    public Select where(Condition where) {
        this.where = where;
        return this;
    }

    @Override
    public Select where(SearchQuery searchQuery) {
        this.searchQuery = searchQuery;
        return this;
    }

    @Override
    public Select limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("LIMIT must > 0, but has " + limit);
        }
        this.limit = limit;
        return this;
    }

    @Override
    public Select limit(int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("OFFSET must >= 0, but has " + offset);
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("LIMIT must > 0, but has " + limit);
        }
        this.offset = offset;
        this.limit = limit;
        return this;
    }

    @Override
    public Select offset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("OFFSET must >= 0, but has " + offset);
        }
        this.offset = offset;
        return this;
    }

    @Override
    public void internalSetTTL(long ttl) {
        throw new UnsupportedOperationException("Setting TTLs on Select is not supported");
    }

    @Override
    public Select timestamp(long ts) {
        return this.timestamp(ts, ts + 1L);
    }

    @Override
    public Select timestamp(long minStamp, long maxStamp) {
        SchemaUtils.validateTimestamp(minStamp);
        SchemaUtils.validateTimestamp(maxStamp);
        if (maxStamp < minStamp) {
            throw new IllegalArgumentException("maxStamp must be greater than minStamp, but has maxStamp=" + maxStamp + ", minStamp=" + minStamp);
        }
        this.minStamp = minStamp;
        this.maxStamp = maxStamp;
        return this;
    }

    @Override
    public Select versions(int maxVersionsToRead) {
        if (maxVersionsToRead <= 0) {
            throw new IllegalArgumentException("VERSIONS must >= 0, but has " + maxVersionsToRead);
        }
        this.maxVersions = maxVersionsToRead;
        return this;
    }

    @Override
    public Select hint(Hint hint) {
        return this.hint(hint, null);
    }

    @Override
    public Select hint(Hint hint, String detail) {
        this.hint = hint != null ? new HintInfo(hint, detail) : null;
        return this;
    }

    @Override
    public Select family(byte[] ... families) {
        this.families = CollectionUtils.newArrayListWithCapacity(families.length);
        Collections.addAll(this.families, families);
        return this;
    }

    @Override
    public Select explain() {
        this.isExplain = true;
        return this;
    }

    @Override
    public Select explain(boolean isExplain) {
        this.isExplain = isExplain;
        return this;
    }

    @Override
    public Select orderBy(List<OrderedColumnKey> columns) {
        this.orderByColumns = columns;
        return this;
    }

    public List<ColumnKey> getColumns() {
        return this.columns;
    }

    public Condition getWhere() {
        return this.where;
    }

    public SearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    public long getMinTimestamp() {
        return this.minStamp;
    }

    public long getMaxTimestamp() {
        return this.maxStamp;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public boolean hasLimit() {
        return this.limit != -1;
    }

    public boolean hasOffset() {
        return this.offset > 0;
    }

    public void removeLimit() {
        this.limit = -1;
    }

    public void removeOffset() {
        this.offset = 0;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isExplain() {
        return this.isExplain;
    }

    public HintInfo getHint() {
        return this.hint;
    }

    public List<byte[]> getFamilies() {
        return this.families;
    }

    public List<OrderedColumnKey> getOrderByColumns() {
        return this.orderByColumns;
    }

    public boolean isDigestQuery() {
        return this.isDigestQuery;
    }

    public boolean isSearchIndexQuery() {
        return this.isSearchIndexQuery;
    }

    public boolean isAllowFiltering() {
        return this.allowFiltering != null && this.allowFiltering != false;
    }

    @Override
    public LSelect allowFiltering(boolean value) {
        this.allowFiltering = value;
        return this;
    }

    @Override
    public LSelect setQueryHotOnly(Boolean hotOnly) {
        if (hotOnly == null) {
            this.removeAttribute("HOT_ONLY");
        } else {
            this.setAttribute("HOT_ONLY", Bytes.toBytes(hotOnly));
        }
        return this;
    }

    @Override
    public boolean isQueryHotOnly() {
        byte[] value = this.getAttribute("HOT_ONLY");
        return value != null && Bytes.toBoolean(value);
    }

    @Override
    public Select setBatchReturnCount(int batchCount) {
        if (batchCount <= 0) {
            throw new IllegalArgumentException("The value of batch return count must > 0, but has " + batchCount);
        }
        this.batchCount = batchCount;
        return this;
    }

    @Override
    public Select setBatchReturnSize(int size) {
        this.batchSize = size;
        return this;
    }

    public int getBatchReturnCount() {
        return this.batchCount;
    }

    public int getBatchReturnSize() {
        return this.batchSize;
    }

    public boolean hasBatchReturnCount() {
        return this.batchCount != -1;
    }

    public boolean hasBatchReturnSize() {
        return this.batchCount > 0;
    }

    public Select setSupportEmptyResult(boolean supportEmptyResult) {
        this.supportEmptyResult = supportEmptyResult;
        return this;
    }

    public boolean isSupportEmptyResult() {
        if (this.supportEmptyResult == null) {
            return true;
        }
        return this.supportEmptyResult;
    }

    public LQueryResults.SelectContext getContext() {
        return this.context;
    }

    public void setContext(LQueryResults.SelectContext context) {
        this.context = context;
    }

    public void setDigest(byte[] digest) throws LindormException {
        try {
            this.context = new LQueryResults.SelectContext();
            this.context.setDigest(digest);
            this.isDigestQuery = true;
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    @Override
    public void setSearchCursor(String cursor) {
        if (this.context == null) {
            this.context = new LQueryResults.SelectContext();
        }
        this.context.setSearchCursor(cursor);
        this.isSearchIndexQuery = true;
    }

    @Override
    public void setPagingContext(PagingContext pagingContext) throws LindormException {
        if (!this.semanticEquals(pagingContext.getLastSelect())) {
            throw new LindormException(String.format("pagingState only works for the same query. last select query: %s, current select query: %s", pagingContext.getLastSelect(), this));
        }
        this.setContext(pagingContext.getContext());
        this.isPagingContextSet = true;
    }

    @Override
    public boolean isPagingContextSet() {
        return this.isPagingContextSet;
    }

    public LindormTableService getTableService() {
        return (LindormTableService)this.service;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.columns.size());
        for (ColumnKey col : this.columns) {
            col.writeTo(out);
        }
        if (this.where != null) {
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.where));
            this.where.writeTo(out);
        } else {
            WritableUtils.writeVInt(out, ExpressionType.NONE_EXPRESSION_ORDINAL);
        }
        WritableUtils.writeVLong(out, this.minStamp);
        WritableUtils.writeVLong(out, this.maxStamp);
        WritableUtils.writeVInt(out, this.offset);
        WritableUtils.writeVInt(out, this.limit);
        WritableUtils.writeVInt(out, this.maxVersions);
        this.context.writeTo(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int columnNumber = WritableUtils.readVInt(in);
        if (columnNumber > 0) {
            this.columns = CollectionUtils.newArrayListWithCapacity(columnNumber);
            for (int i = 0; i < columnNumber; ++i) {
                ColumnKey col = new ColumnKey();
                col.readFrom(in);
                this.columns.add(col);
            }
        } else {
            this.columns = Collections.emptyList();
        }
        this.where = (Condition)ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
        if (this.where != null) {
            this.where.readFrom(in);
        }
        this.minStamp = WritableUtils.readVLong(in);
        this.maxStamp = WritableUtils.readVLong(in);
        this.offset = WritableUtils.readVInt(in);
        this.limit = WritableUtils.readVInt(in);
        this.maxVersions = WritableUtils.readVInt(in);
        this.context = new LQueryResults.SelectContext();
        this.context.readFrom(in);
        this.initFromAttributes();
    }

    private void setupAttributes() throws LindormException {
        try {
            if (this.isExplain) {
                this.setAttribute(EXPLAIN_ATTR, DataTypeUtils.TRUE_BYTES);
            } else {
                this.setAttribute(EXPLAIN_ATTR, (byte[])null);
            }
            if (this.hint != null) {
                this.setAttribute(HINT_ATTR, HintInfo.toBytes(this.hint));
            } else {
                this.setAttribute(HINT_ATTR, (byte[])null);
            }
            if (this.batchCount != -1) {
                this.setAttribute(BATCH_ATTR, Bytes.toBytes(this.batchCount));
            } else {
                this.removeAttribute(BATCH_ATTR);
            }
            if (this.families != null) {
                this.setAttribute(FAMILY_ATTR, LindormObjectUtils.byteArraysToBytes(this.families));
            } else {
                this.removeAttribute(FAMILY_ATTR);
            }
            if (!this.orderByColumns.isEmpty()) {
                this.writeOrderByColumnsToAttribute();
            } else {
                this.removeAttribute(ORDER_BY_ATTR);
            }
            if (this.allowFiltering != null) {
                this.setAttribute(ALLOW_FILTERING_ATTR, Bytes.toBytes(this.allowFiltering));
            } else {
                this.removeAttribute(ALLOW_FILTERING_ATTR);
            }
            if (this.supportEmptyResult != null) {
                this.setAttribute("EMPTY", Bytes.toBytes(this.supportEmptyResult));
            } else {
                this.setAttribute("EMPTY", Bytes.toBytes(true));
            }
            if (this.batchSize > 0) {
                this.setAttribute(BATCHSIZE_ATTR, Bytes.toBytes(this.batchSize));
            } else {
                this.removeAttribute(BATCHSIZE_ATTR);
            }
            if (this.searchQuery != null) {
                this.setAttribute(SEARCH_QUERY_ATTR, this.searchQuery.toBytes());
            } else {
                this.removeAttribute(SEARCH_QUERY_ATTR);
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void writeOrderByColumnsToAttribute() throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(data);
        WritableUtils.writeVInt(out, this.orderByColumns.size());
        for (ColumnKey columnKey : this.orderByColumns) {
            columnKey.writeTo(out);
        }
        out.close();
        this.setAttribute(ORDER_BY_ATTR, data.toByteArray());
    }

    private void initFromAttributes() throws LindormException {
        try {
            byte[] searchQueryBytes;
            byte[] supportEmptyResult;
            byte[] allowFilteringBytes;
            byte[] orderByColumnsBytes;
            byte[] familiesBytes;
            byte[] batchCountBytes;
            byte[] hintBytes;
            byte[] explainMarker = this.getAttribute(EXPLAIN_ATTR);
            if (explainMarker != null) {
                this.isExplain = true;
            }
            if ((hintBytes = this.getAttribute(HINT_ATTR)) != null) {
                this.hint = HintInfo.fromBytes(hintBytes);
            }
            if ((batchCountBytes = this.getAttribute(BATCH_ATTR)) != null) {
                this.batchCount = Bytes.toInt(batchCountBytes);
            }
            if ((familiesBytes = this.getAttribute(FAMILY_ATTR)) != null) {
                this.families = LindormObjectUtils.byteArraysFromBytes(familiesBytes);
            }
            if ((orderByColumnsBytes = this.getAttribute(ORDER_BY_ATTR)) != null) {
                this.readOrderByColumnsFromAttribute(orderByColumnsBytes);
            }
            if ((allowFilteringBytes = this.getAttribute(ALLOW_FILTERING_ATTR)) != null) {
                this.allowFiltering = Bytes.toBoolean(allowFilteringBytes);
            }
            this.supportEmptyResult = (supportEmptyResult = this.getAttribute("EMPTY")) != null ? Boolean.valueOf(Bytes.toBoolean(supportEmptyResult)) : Boolean.valueOf(false);
            byte[] batchSzieBytes = this.getAttribute(BATCHSIZE_ATTR);
            if (batchSzieBytes != null) {
                this.batchSize = Bytes.toInt(batchSzieBytes);
            }
            if ((searchQueryBytes = this.getAttribute(SEARCH_QUERY_ATTR)) != null) {
                this.searchQuery = new SearchQuery();
                this.searchQuery.fromBytes(searchQueryBytes);
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void readOrderByColumnsFromAttribute(byte[] data) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int size = WritableUtils.readVInt(in);
        this.orderByColumns = CollectionUtils.newArrayListWithCapacity(size);
        for (int i = 0; i < size; ++i) {
            OrderedColumnKey column = new OrderedColumnKey();
            column.readFrom(in);
            this.orderByColumns.add(column);
        }
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("SELECT ");
        if (this.hint != null) {
            ret.append(" /*+");
            ret.append(this.hint.toString());
            ret.append("*/ ");
        }
        if (this.columns == null || this.columns.isEmpty()) {
            ret.append(" * ");
        } else {
            int columnsNum = 0;
            for (ColumnKey column : this.columns) {
                ret.append(column.toString());
                ret.append(",");
                if (++columnsNum <= 10) continue;
                break;
            }
            ret.setLength(ret.length() - 1);
            if (columnsNum < this.columns.size()) {
                ret.append(",");
                ret.append("[...count=" + this.columns.size() + "]");
            }
        }
        ret.append(" from ");
        ret.append(this.tableName);
        if (this.where != null) {
            ret.append(" where ");
            ret.append(this.where.toString());
        }
        if (this.minStamp != 0L || this.maxStamp != Long.MAX_VALUE) {
            ret.append(" timestamps ");
            ret.append(this.minStamp);
            ret.append(",");
            ret.append(this.maxStamp);
        }
        if (this.orderByColumns != null && !this.orderByColumns.isEmpty()) {
            ret.append(" order by ");
            for (OrderedColumnKey orderByColumn : this.orderByColumns) {
                ret.append(orderByColumn.toString());
                ret.append(",");
            }
            ret.setLength(ret.length() - 1);
        }
        if (this.offset != 0 || this.limit != -1) {
            ret.append(" limit ");
            ret.append(this.offset);
            ret.append(",");
            ret.append(this.limit);
        }
        if (this.maxVersions != 1) {
            ret.append(" versions ");
            ret.append(this.maxVersions);
        }
        if (this.batchCount != -1) {
            ret.append(" batchReturnCount ");
            ret.append(this.batchCount);
        }
        if (this.batchSize > 0) {
            ret.append(" BatchReturnSize ");
            ret.append(this.batchSize);
        }
        if (this.supportEmptyResult != null) {
            ret.append(" supportEmptyResult ");
            ret.append(this.isSupportEmptyResult());
        }
        return ret.toString();
    }

    public boolean semanticEquals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LSelect)) {
            return false;
        }
        LSelect other = (LSelect)obj;
        if (!this.columns.equals(other.columns)) {
            return false;
        }
        if (this.where == null != (other.where == null)) {
            return false;
        }
        if (this.where != null && !this.where.equals(other.where)) {
            return false;
        }
        if (this.minStamp != other.minStamp || this.maxStamp != other.maxStamp) {
            return false;
        }
        if (this.offset != other.offset || this.limit != other.limit) {
            return false;
        }
        if (this.maxVersions != other.maxVersions) {
            return false;
        }
        return this.supportEmptyResult == other.supportEmptyResult;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LSelect)) {
            return false;
        }
        LSelect other = (LSelect)obj;
        if (!this.columns.equals(other.columns)) {
            return false;
        }
        if (this.where == null != (other.where == null)) {
            return false;
        }
        if (this.where != null && !this.where.equals(other.where)) {
            return false;
        }
        if (this.minStamp != other.minStamp || this.maxStamp != other.maxStamp) {
            return false;
        }
        if (this.offset != other.offset || this.limit != other.limit) {
            return false;
        }
        if (this.maxVersions != other.maxVersions) {
            return false;
        }
        if (this.batchCount != other.batchCount) {
            return false;
        }
        if (this.batchSize != other.batchSize) {
            return false;
        }
        return this.supportEmptyResult == other.supportEmptyResult;
    }

    @Override
    protected byte[] computeRowKey(TableMeta meta) throws LindormException {
        try {
            if (this.context != null && this.context.getNextStartPrimaryKey() != null) {
                return this.context.getNextStartPrimaryKey();
            }
            return CompilerUtils.getRowKeyForRouting(meta, this.where);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public Future<List<Row>> executeAsync() throws LindormException {
        final ClientCompletableFuture<List<Row>> future = new ClientCompletableFuture<List<Row>>();
        this.executeAsync(new AsyncCallback<List<Row>>(){

            @Override
            public void onComplete(List<Row> result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public void executeAsync(AsyncCallback<List<Row>> callback) throws LindormException {
        LSelect.validate(this);
        AsyncSelectHandler asyncSelectHandler = new AsyncSelectHandler(callback, OperationContext.OperationType.SELECT, System.currentTimeMillis());
        asyncSelectHandler.callOnce();
    }

    @Override
    public QueryResults execute() throws LindormException {
        LSelect.validate(this);
        return new LQueryResults(this);
    }

    private LServerCallable<LQueryResults.PartialResult> buildSelectCallable() {
        return new LServerCallable<LQueryResults.PartialResult>((DmlOperation)this, OperationContext.OperationType.SELECT){

            @Override
            public LQueryResults.PartialResult call() throws Exception {
                return this.server.select(LSelect.this);
            }
        };
    }

    @Override
    public void setupRouteKey() throws LindormException {
        if (!this.isExplain) {
            super.setupRouteKey();
        } else {
            this.routeKey = null;
            this.tryGetTableMeta();
        }
    }

    private void nextAsync(AsyncSelectHandler asyncSelectHandler) throws LindormException {
        int operationTimeout = asyncSelectHandler.getRemainingTime();
        OperationContext.OperationType operationType = OperationContext.OperationType.SELECT;
        RetryingCaller<LQueryResults.PartialResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(operationTimeout, this.getGlitchTimeout(), this.service.getDoAsUser());
        LServerCallable<LQueryResults.PartialResult> selectCallable = this.buildSelectCallable();
        this.setupRouteKey();
        Object traceContext = this.service.startOperationAsync(this.tableName, operationType);
        asyncSelectHandler.setTracerContext(traceContext);
        asyncSelectHandler.setCaller(retryingCaller);
        retryingCaller.withRetriesAsync(selectCallable, asyncSelectHandler);
    }

    protected void checkResultCompatibility(LQueryResults.PartialResult result) throws IOException {
        if (result != null && !result.isPartialResultDone()) {
            throw new DoNotRetryIOException("Some rows are not finished, maybe we are requesting LDServer with a older version?");
        }
    }

    public LQueryResults.PartialResult next() throws LindormException {
        long start = System.currentTimeMillis();
        this.service.startOperation(this.tableName, OperationContext.OperationType.SELECT);
        RetryingCaller<LQueryResults.PartialResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        try {
            LServerCallable<LQueryResults.PartialResult> selectCallable = this.buildSelectCallable();
            this.setupRouteKey();
            LQueryResults.PartialResult result = retryingCaller.withRetries(selectCallable);
            this.handleResultAttributes(this, result);
            this.checkResultCompatibility(result);
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, OperationContext.OperationType.SELECT, System.currentTimeMillis() - start, result.getRowNum());
            result.setOrderedColumns(this.getOrderedColumnKeys());
            this.service.endOperationSuccessfully(this.tableName, retryingCaller);
            LQueryResults.PartialResult partialResult = result;
            return partialResult;
        }
        catch (Throwable t) {
            if (t instanceof TableNotFoundException) {
                this.service.getLConnection().getTableMetaCache().removeTable(this.namespace, this.tableName);
            }
            String msg = this.buildErrorMsg(OperationContext.OperationType.SELECT, t, System.currentTimeMillis() - start);
            LindormException error = new LindormException(msg);
            if (this.service.isInitCauseBy()) {
                error.initCause(t);
            }
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, OperationContext.OperationType.SELECT, error);
            this.service.endOperationExceptionally(this.tableName, retryingCaller, t);
            throw error;
        }
        finally {
            this.getContext().cleanStatus();
        }
    }

    private static void validate(LSelect select) throws LindormException {
        if (select.getTableName() == null || select.getTableName().isEmpty()) {
            throw new LindormException("Empty table name for SELECT, please call from() to set one.");
        }
    }

    public LSelect shallowCopy() {
        LSelect ret = new LSelect();
        ret.namespace = this.namespace;
        ret.tableName = this.tableName;
        ret.columns = this.columns;
        ret.minStamp = this.minStamp;
        ret.maxStamp = this.maxStamp;
        ret.offset = this.offset;
        ret.limit = this.limit;
        ret.maxVersions = this.maxVersions;
        ret.batchCount = this.batchCount;
        ret.batchSize = this.batchSize;
        ret.supportEmptyResult = this.supportEmptyResult;
        ret.orderByColumns = this.orderByColumns;
        if (this.isQueryHotOnly()) {
            ret.setQueryHotOnly(this.isQueryHotOnly());
        }
        return ret;
    }

    private List<ColumnKey> getOrderedColumnKeys() throws LindormException {
        if (this.columns != null && !this.columns.isEmpty()) {
            return this.columns;
        }
        TableMeta meta = this.service.getTableMetaFromCache(this.tableName);
        if (meta == null) {
            throw new LindormException("Failed to get table meta for " + this.tableName + " current operation: " + this);
        }
        return meta.getAllColumnKeys();
    }

    @Override
    public LSelect setMustReturnKVForExistentRow(boolean value) {
        this.setAttribute("KV_EXISTENT_ROW", Bytes.toBytes(value));
        return this;
    }

    @Override
    public boolean mustReturnKVForExistentRow() {
        byte[] bytes = this.getAttribute("KV_EXISTENT_ROW");
        return bytes != null && Bytes.toBoolean(bytes);
    }

    private class AsyncSelectHandler
    extends DmlOperation.AsyncMutationHandler<List<Row>, LQueryResults.PartialResult> {
        List<Row> resultsToReturn;
        private boolean isFirstCall;

        public AsyncSelectHandler(AsyncCallback<List<Row>> callback, OperationContext.OperationType operationType, long startTime) {
            super(LSelect.this, callback, operationType, startTime, null);
            this.resultsToReturn = new ArrayList<Row>();
            this.isFirstCall = true;
        }

        @Override
        protected List<Row> getReturnValue(LQueryResults.PartialResult result) {
            throw new UnsupportedOperationException();
        }

        public void setTracerContext(Object traceContext) {
            this.traceContext = traceContext;
        }

        @Override
        protected int getAffectedRows(LQueryResults.PartialResult result) {
            return result.getRowNum();
        }

        @Override
        public void onComplete(LQueryResults.PartialResult result) {
            this.isFirstCall = false;
            if (LSelect.this.getContext() != null) {
                LSelect.this.getContext().cleanStatus();
            }
            try {
                LSelect.this.checkResultCompatibility(result);
            }
            catch (Throwable t) {
                this.onError(t);
                return;
            }
            LSelect.this.service.endOperationAsyncSuccessfully(this.traceContext, LSelect.this.tableName, this.caller);
            LSelect.this.handleResultAttributes(LSelect.this, result);
            int affectedRows = this.getAffectedRows(result);
            LSelect.this.service.getLConnection().getTableMetricsManager().onOperationSuccess(LSelect.this.namespace, LSelect.this.tableName, this.operationType, System.currentTimeMillis() - this.startTime, affectedRows);
            this.resultsToReturn.addAll(result.getRows());
            if (!LQueryResults.hasMore(result.getContext())) {
                this.callback.onComplete(this.resultsToReturn);
            } else {
                this.callOnce(result);
            }
        }

        @Override
        public void onError(Throwable exception) {
            if (LSelect.this.getContext() != null) {
                LSelect.this.getContext().cleanStatus();
            }
            super.onError(exception);
        }

        @Override
        public boolean isRetrying() {
            return !this.isFirstCall;
        }

        public void callOnce() {
            this.callOnce(null);
        }

        private void callOnce(LQueryResults.PartialResult lastReturnedResult) {
            try {
                LQueryResults.SelectContext ctx = null;
                if (lastReturnedResult == null) {
                    ctx = new LQueryResults.SelectContext();
                    if (LSelect.this.hasLimit()) {
                        if (LSelect.this.getOffset() > 0) {
                            ctx.setOffset(LSelect.this.getOffset());
                        }
                        ctx.setLimit(LSelect.this.getLimit());
                    }
                } else {
                    ctx = lastReturnedResult.getContext();
                }
                LSelect.this.setContext(ctx);
                LSelect.this.nextAsync(this);
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }

        public int getRemainingTime() {
            if (this.isFirstCall) {
                return LSelect.this.getOperationTimeout();
            }
            return (int)Math.max(0L, (long)LSelect.this.getOperationTimeout() - (System.currentTimeMillis() - this.startTime));
        }
    }
}

