/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.tableservice.index.LSearchIndexDescriptor;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.DataInputBuffer;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.IndexState;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SearchIndexMeta
extends VersionedObjectWithAttributes {
    public static final String SEARCH_INDEX_META_KEY = "SEARCH_INDEX_META";
    private Map<String, SearchIndexMeta> indexMetas = new HashMap<String, SearchIndexMeta>();
    private String parentName;
    private String indexName;
    private IndexState indexState;
    private List<ColumnKey> indexedColumns;
    private Map<ColumnKey, LColumn> columnsByName;

    public SearchIndexMeta() {
    }

    public SearchIndexMeta(LSearchIndexDescriptor desc, TableMeta dataTableMeta) throws LindormException {
        this.setIndexedColumns(desc.getIndexedColumns());
        this.setIndexName(desc.getIndexName());
        this.setParentName(desc.getDataTableName());
        this.setIndexState(desc.getIndexState());
        this.init(dataTableMeta);
    }

    private void init(TableMeta dataTableMeta) throws LindormException {
        this.columnsByName = CollectionUtils.newHashMapWithExpectedSize(this.indexedColumns.size() * 2);
        for (ColumnKey indexedColumn : this.indexedColumns) {
            LColumn lColumn = dataTableMeta.resolveColumn(indexedColumn);
            this.columnsByName.put(indexedColumn, lColumn);
            if (SchemaUtils.isDefaultFamily(indexedColumn.getFamily())) {
                ColumnKey ckWithoutFamily = new ColumnKey(null, indexedColumn.getQualifier());
                this.columnsByName.put(ckWithoutFamily, lColumn);
                continue;
            }
            if (null != indexedColumn.getFamily()) continue;
            ColumnKey ckWithDefaultFamily = new ColumnKey(SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, indexedColumn.getQualifier());
            this.columnsByName.put(ckWithDefaultFamily, lColumn);
        }
    }

    public void addIndex(TableMeta dataTableMeta, SearchIndexMeta meta) throws LindormException {
        meta.init(dataTableMeta);
        this.indexMetas.put(meta.getIndexName(), meta);
    }

    public Map<String, SearchIndexMeta> getIndexMetas() {
        return this.indexMetas;
    }

    public void removeIndexMeta(String indexName) {
        this.indexMetas.remove(indexName);
    }

    public SearchIndexMeta getSearchIndexMeta(String index) {
        return this.indexMetas.get(index);
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public IndexState getIndexState() {
        return this.indexState;
    }

    public void setIndexState(IndexState indexState) {
        this.indexState = indexState;
    }

    public List<ColumnKey> getIndexedColumns() {
        return this.indexedColumns;
    }

    public void setIndexedColumns(List<ColumnKey> indexedColumns) {
        this.indexedColumns = indexedColumns;
    }

    public LColumn resolveSearchIndexColumn(ColumnKey ck) {
        return this.columnsByName.get(ck);
    }

    protected void initFromAttributes(TableMeta tableMeta) throws LindormException {
        try {
            byte[] indexMetaBytes = tableMeta.getAttribute(SEARCH_INDEX_META_KEY);
            if (indexMetaBytes != null) {
                this.indexMetas = SearchIndexMeta.tableMetaMapFromBytes(indexMetaBytes);
            }
            for (SearchIndexMeta meta : this.indexMetas.values()) {
                meta.init(tableMeta);
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    protected void setupAttributes(TableMeta tableMeta) throws LindormException {
        try {
            if (null == this.indexMetas || this.indexMetas.isEmpty()) {
                tableMeta.removeAttribute(SEARCH_INDEX_META_KEY);
            } else {
                tableMeta.setAttribute(SEARCH_INDEX_META_KEY, SearchIndexMeta.tableMetaMapToBytes(this.indexMetas));
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public synchronized void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.parentName);
        WritableUtils.writeString(out, this.indexName);
        WritableUtils.writeString(out, this.indexState.name());
        byte[] columnKeysToBytes = SchemaUtils.columnKeysToBytes(this.indexedColumns);
        WritableUtils.writeVInt(out, columnKeysToBytes.length);
        out.write(columnKeysToBytes);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.parentName = WritableUtils.readString(in);
        this.indexName = WritableUtils.readString(in);
        this.indexState = IndexState.valueOf(WritableUtils.readString(in));
        int count = WritableUtils.readVInt(in);
        byte[] columnKeysToBytes = new byte[count];
        in.readFully(columnKeysToBytes);
        this.indexedColumns = SchemaUtils.bytesToColumnKeys(columnKeysToBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] tableMetaMapToBytes(Map<String, SearchIndexMeta> metas) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            WritableUtils.writeVInt(out, metas.size());
            for (Map.Entry<String, SearchIndexMeta> entry : metas.entrySet()) {
                entry.getValue().writeTo(out);
            }
            out.close();
            byte[] ret = byteStream.toByteArray();
            out = null;
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, SearchIndexMeta> tableMetaMapFromBytes(byte[] metaBytes) throws IOException {
        DataInputBuffer in = new DataInputBuffer();
        try {
            in.reset(metaBytes, 0, metaBytes.length);
            int size = WritableUtils.readVInt(in);
            ConcurrentHashMap<String, SearchIndexMeta> metas = new ConcurrentHashMap<String, SearchIndexMeta>(size);
            for (int i = 0; i < size; ++i) {
                SearchIndexMeta v = new SearchIndexMeta();
                v.readFrom(in);
                metas.put(v.getIndexName(), v);
            }
            ConcurrentHashMap<String, SearchIndexMeta> concurrentHashMap = metas;
            return concurrentHashMap;
        }
        finally {
            in.close();
        }
    }

    public int hashCode() {
        int h = this.parentName.hashCode();
        h = 31 * h + this.indexName.hashCode();
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SearchIndexMeta)) {
            return false;
        }
        SearchIndexMeta other = (SearchIndexMeta)obj;
        if (!this.parentName.equals(other.getParentName())) {
            return false;
        }
        if (!this.indexName.equals(other.getIndexName())) {
            return false;
        }
        if (!this.indexState.equals((Object)other.getIndexState())) {
            return false;
        }
        return this.indexedColumns.equals(other.getIndexedColumns());
    }
}

