/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.schema.LindormFamilyAttributeConstants;
import com.alibaba.lindorm.client.schema.RowTTLSchema;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FamilyAttributes
extends VersionedObjectWithAttributes {
    public static final Set<String> ALL_FAMILY_ATTRIBUTE_KEYS;

    public static boolean isFamilyAttributes(String attributes) {
        return ALL_FAMILY_ATTRIBUTE_KEYS.contains(attributes);
    }

    public void setToDefaultIfUnset() {
        if (!this.hasAttribute("BLOOMFILTER")) {
            this.setBloomFilterType("ROW");
        }
        if (!this.hasAttribute("MEMSTORE_FILTER")) {
            this.setMemStoreFilterType("DISABLED");
        }
        if (!this.hasAttribute("COMPRESSION")) {
            this.setCompression("NONE");
        }
        if (!this.hasAttribute("DATA_BLOCK_ENCODING")) {
            this.setDataBlockEncoding("INDEX");
        }
        if (!this.hasAttribute("VERSIONS")) {
            this.setMaxVersions(1);
        }
        if (!this.hasAttribute("MIN_VERSIONS")) {
            this.setMinVersions(0);
        }
        if (!this.hasAttribute("DFS_REPLICATION")) {
            this.setDfsReplication((short)2);
        }
        if (!this.hasAttribute("TIME_TO_PURGE_DELETES")) {
            this.setTimeToPurgeDeletes(259200000L);
        }
    }

    public void setTimeToLive(int ttl) {
        if (ttl <= 0) {
            throw new RuntimeException("TTL must > 0, but has " + ttl);
        }
        this.setAttribute("TTL", Integer.toString(ttl));
    }

    public int getTimeToLive() {
        byte[] ttl = this.getAttribute("TTL");
        return ttl == null ? Integer.MAX_VALUE : Integer.valueOf(Bytes.toString(ttl));
    }

    public Integer getTimeToLiveNoDefault() {
        byte[] ttl = this.getAttribute("TTL");
        return ttl == null ? null : Integer.valueOf(Bytes.toString(ttl));
    }

    public void setBlockCacheEnabled(boolean enabled) {
        this.setAttribute("BLOCKCACHE", Boolean.toString(enabled));
    }

    public boolean isBlockCacheEnabled() {
        byte[] blockCache = this.getAttribute("BLOCKCACHE");
        return blockCache == null ? true : Boolean.valueOf(Bytes.toString(blockCache));
    }

    public Boolean isBlockCacheEnabledNoDefault() {
        byte[] blockCache = this.getAttribute("BLOCKCACHE");
        return blockCache == null ? null : Boolean.valueOf(Bytes.toString(blockCache));
    }

    public void setBlockSize(int blocksize) {
        this.setAttribute("BLOCKSIZE", Integer.toString(blocksize));
    }

    public int getBlockSize() {
        Integer blockSize = this.getBlockSizeNoDefault();
        return blockSize == null ? 65536 : blockSize;
    }

    public Integer getBlockSizeNoDefault() {
        byte[] blockSize = this.getAttribute("BLOCKSIZE");
        return blockSize == null ? null : Integer.valueOf(Bytes.toString(blockSize));
    }

    public void setCompression(String compression) {
        this.setAttribute("COMPRESSION", compression);
    }

    public String getCompression() {
        return this.getAttribute("COMPRESSION", "NONE");
    }

    public String getCompressionNoDefault() {
        return this.getAttribute("COMPRESSION", (String)null);
    }

    public void setCompressionCompact(String compression) {
        this.setAttribute("COMPRESSION_COMPACT", compression);
    }

    public String getCompressionCompact() {
        return this.getAttribute("COMPRESSION_COMPACT", "NONE");
    }

    public String getCompressionCompactNoDefault() {
        return this.getAttribute("COMPRESSION_COMPACT", (String)null);
    }

    public void setCompactionCompressionLevel(short level) {
        this.setAttribute("COMPACTION_COMPRESSION_LEVEL", Short.toString(level));
    }

    public short getCompactionCompressionLevel() {
        Short v = this.getCompactionCompressionLevelNoDefault();
        return v != null ? (short)v : (short)-1;
    }

    public Short getCompactionCompressionLevelNoDefault() {
        String n = this.getAttribute("COMPACTION_COMPRESSION_LEVEL", (String)null);
        return n == null ? null : Short.valueOf(n);
    }

    public void setDataBlockEncoding(String encoding) {
        this.setAttribute("DATA_BLOCK_ENCODING", encoding);
    }

    public String getDataBlockEncoding() {
        return this.getAttribute("DATA_BLOCK_ENCODING", "INDEX");
    }

    public String getDataBlockEncodingNoDefault() {
        return this.getAttribute("DATA_BLOCK_ENCODING", (String)null);
    }

    public void setMaxVersions(int maxVersions) {
        this.setAttribute("VERSIONS", Integer.toString(maxVersions));
    }

    public int getMaxVersions() {
        byte[] versions = this.getAttribute("VERSIONS");
        return versions == null ? 1 : Integer.valueOf(Bytes.toString(versions));
    }

    public Integer getMaxVersionsNoDefault() {
        byte[] versions = this.getAttribute("VERSIONS");
        return versions == null ? null : Integer.valueOf(Bytes.toString(versions));
    }

    public void setBloomFilterType(String bloomFilter) {
        this.setAttribute("BLOOMFILTER", bloomFilter);
    }

    public boolean isBFOptimizeOnMajor() {
        return Boolean.valueOf(this.getAttribute("BF_OPTIMIZE_ON_MAJOR", String.valueOf(false)));
    }

    public void setBFOptimizeOnMajor(String shouldOptimize) {
        Boolean.valueOf(shouldOptimize);
        this.setAttribute("BF_OPTIMIZE_ON_MAJOR", shouldOptimize);
    }

    public String isBFOptimizeOnMajorNoDefault() {
        return this.getAttribute("BF_OPTIMIZE_ON_MAJOR", (String)null);
    }

    public String getBloomFilterType() {
        return this.getAttribute("BLOOMFILTER", "ROW");
    }

    public String getMemstoreFilterTypeNoDefault() {
        return this.getAttribute("MEMSTORE_FILTER", (String)null);
    }

    public void setMemStoreFilterType(String type) {
        this.setAttribute("MEMSTORE_FILTER", type);
    }

    public String getMemstoreFilterType() {
        return this.getAttribute("MEMSTORE_FILTER", "DISABLED");
    }

    public String getBloomFilterTypeNoDefault() {
        return this.getAttribute("BLOOMFILTER", (String)null);
    }

    public void setMinVersions(int minVersions) {
        this.setAttribute("MIN_VERSIONS", Integer.toString(minVersions));
    }

    public int getMinVersions() {
        byte[] minVersions = this.getAttribute("MIN_VERSIONS");
        return minVersions == null ? 0 : Integer.valueOf(Bytes.toString(minVersions));
    }

    public Integer getMinVersionsNoDefault() {
        byte[] minVersions = this.getAttribute("MIN_VERSIONS");
        return minVersions == null ? null : Integer.valueOf(Bytes.toString(minVersions));
    }

    public void setDfsReplication(short dfsReplication) {
        this.setAttribute("DFS_REPLICATION", Short.toString(dfsReplication));
    }

    public short getDfsReplication() {
        byte[] dfsReplication = this.getAttribute("DFS_REPLICATION");
        return dfsReplication == null ? (short)2 : Short.valueOf(Bytes.toString(dfsReplication));
    }

    public Short getDfsReplicationNoDefault() {
        byte[] dfsReplication = this.getAttribute("DFS_REPLICATION");
        return dfsReplication == null ? null : Short.valueOf(Bytes.toString(dfsReplication));
    }

    public void setStorageType(String storageType) {
        this.setAttribute("STORAGETYPE", storageType);
    }

    public String getStorageType() {
        return this.getAttribute("STORAGETYPE", "DEFAULT");
    }

    public String getStorageTypeNoDefault() {
        return this.getAttribute("STORAGETYPE", (String)null);
    }

    public void setStorageTypeCompact(String storageType) {
        this.setAttribute("STORAGETYPE_COMPACT", storageType);
    }

    public String getStorageTypeCompact() {
        return this.getAttribute("STORAGETYPE_COMPACT", "DEFAULT");
    }

    public String getStorageTypeCompactNoDefault() {
        return this.getAttribute("STORAGETYPE_COMPACT", (String)null);
    }

    public void setKeepDeletedData(boolean keepDeletedData) {
        this.setAttribute("KEEP_DELETED_DATA", Boolean.toString(keepDeletedData));
    }

    public boolean getKeepDeletedData() {
        Boolean keepDeletedData = this.getKeepDeletedDataNoDefault();
        return keepDeletedData == null ? false : keepDeletedData;
    }

    public Boolean getKeepDeletedDataNoDefault() {
        byte[] keepDeletedData = this.getAttribute("KEEP_DELETED_DATA");
        return keepDeletedData == null ? null : Boolean.valueOf(Bytes.toString(keepDeletedData));
    }

    public void setCompactionMajorPeriod(long compactionMajorPeriod) {
        this.setAttribute("COMPACTION_MAJOR_PERIOD", Long.toString(compactionMajorPeriod));
    }

    public Long getCompactionMajorPeriodNoDefault() {
        byte[] time = this.getAttribute("COMPACTION_MAJOR_PERIOD");
        return time == null ? null : Long.valueOf(Bytes.toString(time));
    }

    public void setHotCompactionPeriod(long period) {
        this.setAttribute("HOT_COMPACTION_PERIOD", Long.toString(period));
    }

    public Long getHotCompactionPeriod() {
        byte[] time = this.getAttribute("HOT_COMPACTION_PERIOD");
        return time == null ? null : Long.valueOf(Bytes.toString(time));
    }

    public void setFileVersion(int version) {
        this.setAttribute("FILEVERSION", Integer.toString(version));
    }

    public Integer getFileVersion() {
        byte[] time = this.getAttribute("FILEVERSION");
        return time == null ? null : Integer.valueOf(Bytes.toString(time));
    }

    public void setCompactionMaxKVNum(int compactionMaxKVNum) {
        this.setAttribute("COMPACTION_MAXKVNUM", Integer.toString(compactionMaxKVNum));
    }

    public Integer getCompactionMaxKVNumNoDefault() {
        byte[] compactionMaxKVNum = this.getAttribute("COMPACTION_MAXKVNUM");
        return compactionMaxKVNum == null ? null : Integer.valueOf(Bytes.toString(compactionMaxKVNum));
    }

    public void setTimeToPurgeDeletes(long timeToPurgeDelete) {
        this.setAttribute("TIME_TO_PURGE_DELETES", Long.toString(timeToPurgeDelete));
    }

    public long getTimeToPurgeDeletes() {
        byte[] time = this.getAttribute("TIME_TO_PURGE_DELETES");
        return time == null ? 259200000L : Long.valueOf(Bytes.toString(time));
    }

    public Long getTimeToPurgeDeletesNoDefault() {
        byte[] time = this.getAttribute("TIME_TO_PURGE_DELETES");
        return time == null ? null : Long.valueOf(Bytes.toString(time));
    }

    public void setInMemory(boolean inMemory) {
        this.setAttribute("IN_MEMORY", Boolean.toString(inMemory));
    }

    public boolean isInMemory() {
        byte[] inMemory = this.getAttribute("IN_MEMORY");
        return inMemory == null ? false : Boolean.valueOf(Bytes.toString(inMemory));
    }

    public Boolean isInMemoryNoDefault() {
        byte[] inMemory = this.getAttribute("IN_MEMORY");
        return inMemory == null ? null : Boolean.valueOf(Bytes.toString(inMemory));
    }

    public void setColdHotSeparateBoundary(String config) {
        this.setAttribute("CHS", config);
    }

    public String getColdHotSeparateBoundary() {
        return this.getAttribute("CHS", (String)null);
    }

    public String getColdHotSeparateBoundaryNoDefault() {
        byte[] value = this.getAttribute("CHS");
        return value == null ? null : Bytes.toString(value);
    }

    public void setColdHotLayerConfig(int i, String config) {
        if (i < 1 || i > 5) {
            throw new IllegalArgumentException("i should be in range 1 to 5");
        }
        String key = "CHS_L" + i;
        this.setAttribute(key, config);
    }

    public String getColdHotLayerConfig(int i) {
        if (i < 1 || i > 5) {
            throw new IllegalArgumentException("i should be in range 1 to 5");
        }
        String key = "CHS_L" + i;
        return this.getAttribute(key, (String)null);
    }

    public String getColdHotLayerConfigNoDefault(int i) {
        if (i < 1 || i > 5) {
            throw new IllegalArgumentException("i should be in range 1 to 5");
        }
        String key = "CHS_L" + i;
        byte[] value = this.getAttribute(key);
        return value == null ? null : Bytes.toString(value);
    }

    public void setColdHotPromoteOnMajor(boolean promoteOnMajor) {
        this.setAttribute("CHS_PROMOTE_ON_MAJOR", Boolean.toString(promoteOnMajor));
    }

    public Boolean isColdHotPromoteOnMajor() {
        byte[] value = this.getAttribute("CHS_PROMOTE_ON_MAJOR");
        return value == null ? LindormFamilyAttributeConstants.COLD_HOT_PROMOTE_ON_MAJOR_DEFAULT : Boolean.valueOf(Bytes.toString(value));
    }

    public Boolean isColdHotPromoteOnMajorNoDefault() {
        byte[] value = this.getAttribute("CHS_PROMOTE_ON_MAJOR");
        return value == null ? null : Boolean.valueOf(Bytes.toString(value));
    }

    public void setRowTTLSchema(String schema) {
        this.setAttribute("ROWTTL_SCHEMA", schema);
    }

    public void setRowTTLSchema(RowTTLSchema schema) {
        this.setAttribute("ROWTTL_SCHEMA", schema.toString());
    }

    public RowTTLSchema getRowTTLSchema() {
        byte[] value = this.getAttribute("ROWTTL_SCHEMA");
        if (value != null) {
            RowTTLSchema ttlSchema = RowTTLSchema.fromString(Bytes.toString(value));
            return ttlSchema;
        }
        return null;
    }

    public void setEncryptionType(String algorithm) {
        this.setAttribute("ENCRYPTION", algorithm);
    }

    public String getEncryptionType() {
        return this.getAttribute("ENCRYPTION", "NONE");
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FamilyAttributes)) {
            return false;
        }
        FamilyAttributes other = (FamilyAttributes)obj;
        return this.equalsAttributes(other);
    }

    static {
        HashSet<String> tmp = new HashSet<String>(64);
        tmp.add("BLOOMFILTER");
        tmp.add("MEMSTORE_FILTER");
        tmp.add("COMPRESSION");
        tmp.add("COMPRESSION_COMPACT");
        tmp.add("COMPACTION_COMPRESSION_LEVEL");
        tmp.add("DATA_BLOCK_ENCODING");
        tmp.add("STORAGETYPE");
        tmp.add("STORAGETYPE_COMPACT");
        tmp.add("TTL");
        tmp.add("VERSIONS");
        tmp.add("MIN_VERSIONS");
        tmp.add("DFS_REPLICATION");
        tmp.add("TIME_TO_PURGE_DELETES");
        tmp.add("IN_MEMORY");
        tmp.add("BLOCKSIZE");
        tmp.add("BLOCKCACHE");
        tmp.add("COMPACTION_MAJOR_PERIOD");
        tmp.add("COMPACTION_MAXKVNUM");
        tmp.add("KEEP_DELETED_DATA");
        tmp.add("CHS");
        tmp.add("CHS_PROMOTE_ON_MAJOR");
        tmp.add("HOT_COMPACTION_PERIOD");
        tmp.add("ROWTTL_SCHEMA");
        tmp.add("FILEVERSION");
        tmp.add("ENCRYPTION");
        for (int i = 0; i <= 5; ++i) {
            tmp.add("CHS_L" + i);
        }
        ALL_FAMILY_ATTRIBUTE_KEYS = Collections.unmodifiableSet(tmp);
    }
}

