/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.ExternalIndexRowFormatterType;
import com.alibaba.lindorm.client.core.meta.ExternalIndexType;
import com.alibaba.lindorm.client.core.meta.ExternalTableType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.schema.IndexState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExternalIndexConfig
extends VersionedObjectWithAttributes {
    private static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String INDEX_STATE = "INDEX_STATE";
    private static final String EXPAND_INDEX_NAME = "EXPAND_INDEX_NAME";
    private String targetIndexName = null;
    private ExternalIndexType indexType = null;
    private Boolean expandIndexName = true;
    private ExternalIndexRowFormatterType rowFormatterType = null;
    private ExternalTableType tableType = ExternalTableType.WIDECOLUMN;
    private IndexState indexState = null;

    public ExternalIndexConfig() {
    }

    public ExternalIndexConfig(String targetIndexName, ExternalIndexType indexType, ExternalIndexRowFormatterType rowFormatterType) {
        this(targetIndexName, indexType, rowFormatterType, null);
    }

    public ExternalIndexConfig(String targetIndexName, ExternalIndexType indexType, ExternalIndexRowFormatterType rowFormatterType, IndexState indexState) {
        this.targetIndexName = targetIndexName;
        if (indexType != null) {
            this.indexType = indexType;
        }
        if (rowFormatterType != null) {
            this.rowFormatterType = rowFormatterType;
        }
        if (indexState != null) {
            this.indexState = indexState;
        }
    }

    public String getTargetIndexName() {
        return this.targetIndexName;
    }

    public ExternalIndexType getIndexType() {
        return this.indexType;
    }

    public ExternalIndexRowFormatterType getRowFormatterType() {
        return this.rowFormatterType;
    }

    public void setTableType(ExternalTableType tableType) {
        this.tableType = tableType;
    }

    public ExternalTableType getTableType() {
        return this.tableType;
    }

    public void setIndexState(IndexState indexState) {
        this.indexState = indexState;
    }

    public IndexState getIndexState() {
        return this.indexState;
    }

    public boolean shouldExpandIndexName() {
        return this.expandIndexName != null && this.expandIndexName != false;
    }

    public void setExpandIndexName(boolean value) {
        this.expandIndexName = value;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        WritableUtils.writeString(out, this.targetIndexName);
        if (this.indexType == null) {
            WritableUtils.writeString(out, null);
        } else {
            WritableUtils.writeString(out, this.indexType.name());
        }
        if (this.rowFormatterType == null) {
            WritableUtils.writeString(out, null);
        } else {
            WritableUtils.writeString(out, this.rowFormatterType.name());
        }
    }

    private void setupAttributes() {
        if (this.tableType != null) {
            this.setAttribute(TABLE_TYPE, this.tableType.name());
        }
        if (this.indexState != null) {
            this.setAttribute(INDEX_STATE, this.indexState.name());
        }
        if (this.expandIndexName != null) {
            this.setAttribute(EXPAND_INDEX_NAME, Bytes.toBytes(this.expandIndexName.toString()));
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.targetIndexName = WritableUtils.readString(in);
        String indexTypeStr = WritableUtils.readString(in);
        this.indexType = indexTypeStr == null || indexTypeStr.length() == 0 ? null : ExternalIndexType.valueOf(indexTypeStr);
        String rowFormatterTypeStr = WritableUtils.readString(in);
        this.rowFormatterType = rowFormatterTypeStr == null || rowFormatterTypeStr.length() == 0 ? null : ExternalIndexRowFormatterType.valueOf(rowFormatterTypeStr);
        this.initFromAttributes();
    }

    private void initFromAttributes() {
        byte[] expandIndexNameBytes;
        byte[] indexStateBytes;
        byte[] tableTypeBytes = this.getAttribute(TABLE_TYPE);
        if (tableTypeBytes != null) {
            this.tableType = ExternalTableType.valueOf(Bytes.toString(tableTypeBytes));
        }
        if ((indexStateBytes = this.getAttribute(INDEX_STATE)) != null) {
            this.indexState = IndexState.valueOf(Bytes.toString(indexStateBytes));
        }
        if ((expandIndexNameBytes = this.getAttribute(EXPAND_INDEX_NAME)) != null) {
            this.expandIndexName = Boolean.parseBoolean(Bytes.toString(expandIndexNameBytes));
        }
    }

    @Override
    public String toString() {
        return "targetIndexName=" + (this.targetIndexName == null ? "" : this.targetIndexName) + ", indexType=" + (Object)((Object)this.indexType) + ", rowFormatterType=" + (Object)((Object)this.rowFormatterType) + ", indexState=" + (Object)((Object)this.indexState);
    }
}

