/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.TableKey;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocationCache {
    static final Log LOG = LogFactory.getLog(LocationCache.class);
    private final ConcurrentHashMap<TableKey, ConcurrentSkipListMap<byte[], Location>> cachedRegionLocations = new ConcurrentHashMap();

    private ConcurrentSkipListMap<byte[], Location> getTableLocations(String namespace, byte[] tableName) {
        return this.getTableLocations(namespace, Bytes.toString(tableName));
    }

    public ConcurrentSkipListMap<byte[], Location> getTableLocations(String namespace, String tableName) {
        ConcurrentSkipListMap v;
        TableKey tableKey = new TableKey(namespace, tableName);
        ConcurrentSkipListMap<byte[], Location> result = this.cachedRegionLocations.get(tableKey);
        if (result == null && (result = this.cachedRegionLocations.putIfAbsent(tableKey, v = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR))) == null) {
            result = v;
        }
        return result;
    }

    public void cacheLocation(Location location) {
        byte[] startKey = location.getStartKey();
        String namespace = location.getNamespace();
        byte[] tableName = location.getTableName();
        ConcurrentSkipListMap<byte[], Location> tableLocations = this.getTableLocations(namespace, tableName);
        tableLocations.put(startKey, location);
        Location seenLocation = null;
        byte[] endKey = location.getEndKey();
        if (Bytes.equals(endKey, LindormClientConstants.EMPTY_END_ROW)) {
            seenLocation = tableLocations.get(tableLocations.lastKey());
        } else {
            Map.Entry<byte[], Location> e = tableLocations.lowerEntry(endKey);
            if (e != null) {
                seenLocation = e.getValue();
            }
        }
        if (seenLocation != null && !seenLocation.equals(location)) {
            LOG.warn((Object)("Cached location " + seenLocation + " couldn't be seen," + " remove it because of new location " + location));
            tableLocations.remove(seenLocation.getStartKey());
        }
        LOG.debug((Object)("Cached location for " + location));
    }

    public Location getCachedLocation(String namespace, String tableName, byte[] routeKey) {
        ConcurrentSkipListMap<byte[], Location> tableLocations = this.getTableLocations(namespace, tableName);
        if (tableLocations.isEmpty()) {
            return null;
        }
        Map.Entry<byte[], Location> e = tableLocations.floorEntry(routeKey);
        if (e == null) {
            return null;
        }
        Location possibleRegion = e.getValue();
        byte[] endKey = possibleRegion.getEndKey();
        if (Bytes.equals(endKey, LindormClientConstants.EMPTY_END_ROW) || Bytes.compareTo(endKey, 0, endKey.length, routeKey, 0, routeKey.length) > 0) {
            return possibleRegion;
        }
        return null;
    }

    public void deleteCachedLocation(String namespace, byte[] tableName, byte[] routeKey) {
        Location rl;
        ConcurrentSkipListMap<byte[], Location> tableLocations = this.getTableLocations(namespace, tableName);
        if (!tableLocations.isEmpty() && (rl = this.getCachedLocation(namespace, Bytes.toString(tableName), routeKey)) != null) {
            tableLocations.remove(rl.getStartKey());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed " + rl + " from cache " + "because of " + Bytes.toStringBinary(routeKey)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCachedLocationForServer(LDServerAddress server) {
        boolean deleted = false;
        ConcurrentHashMap<TableKey, ConcurrentSkipListMap<byte[], Location>> concurrentHashMap = this.cachedRegionLocations;
        synchronized (concurrentHashMap) {
            for (Map map : this.cachedRegionLocations.values()) {
                Iterator iter2 = map.entrySet().iterator();
                while (iter2.hasNext()) {
                    Map.Entry entry = iter2.next();
                    if (!((Location)entry.getValue()).getAddress().equals(server)) continue;
                    iter2.remove();
                    deleted = true;
                }
            }
        }
        if (deleted) {
            LOG.info((Object)("deleted all cached region locations that map to " + server));
        }
    }

    public static class Location
    extends VersionedObjectWithAttributes
    implements Comparable<Location> {
        private static String LEADERMARK = "LEADER";
        private String namespace;
        private byte[] tableName;
        private LDServerAddress address;
        private byte[] startKey;
        private byte[] endKey;
        private boolean isLeader = true;
        private long ts = System.currentTimeMillis();

        public String getNamespace() {
            return this.namespace;
        }

        public byte[] getTableName() {
            return this.tableName;
        }

        public LDServerAddress getAddress() {
            return this.address;
        }

        public byte[] getStartKey() {
            return this.startKey;
        }

        public byte[] getEndKey() {
            return this.endKey;
        }

        private Location() {
        }

        public long getTs() {
            return this.ts;
        }

        public Location(String namespace, byte[] tableName, LDServerAddress ldServerAddress, byte[] startKey, byte[] endKey) {
            this.namespace = namespace;
            this.tableName = tableName;
            this.address = ldServerAddress;
            this.startKey = startKey;
            this.endKey = endKey;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("namespace=").append(this.namespace);
            builder.append(", tableName=").append(Bytes.toString(this.tableName));
            builder.append(", startKey=").append(Bytes.toStringBinary(this.startKey));
            builder.append(", endKey=").append(Bytes.toStringBinary(this.endKey));
            builder.append(", hostname=");
            if (this.address != null) {
                builder.append(this.address.toString());
            } else {
                builder.append("null");
            }
            return builder.toString();
        }

        public void invalidAddress() {
            this.address = null;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            this.setAttribute(LEADERMARK, Bytes.toBytes(this.isLeader));
            super.writeTo(out);
            WritableUtils.writeString(out, this.namespace);
            Bytes.writeByteArray(out, this.tableName);
            Bytes.writeByteArray(out, this.startKey);
            Bytes.writeByteArray(out, this.endKey);
            this.address.writeTo(out);
            WritableUtils.writeVLong(out, 0L);
        }

        public boolean isLeader() {
            return this.isLeader;
        }

        public void setLeader(boolean leader) {
            this.isLeader = leader;
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            super.readFrom(in);
            this.namespace = WritableUtils.readString(in);
            this.tableName = Bytes.readByteArray(in);
            this.startKey = Bytes.readByteArray(in);
            this.endKey = Bytes.readByteArray(in);
            this.address = new LDServerAddress();
            this.address.readFrom(in);
            WritableUtils.readVLong(in);
            if (this.hasAttribute(LEADERMARK)) {
                this.isLeader = Bytes.toBoolean(this.getAttribute(LEADERMARK));
            }
        }

        @Override
        public int compareTo(Location o) {
            int retCode = this.namespace.compareTo(o.namespace);
            if (retCode != 0) {
                return retCode;
            }
            retCode = Bytes.compareTo(this.tableName, o.tableName);
            if (retCode != 0) {
                return retCode;
            }
            retCode = Bytes.compareTo(this.startKey, o.startKey);
            if (retCode != 0) {
                return retCode;
            }
            retCode = Bytes.compareTo(this.endKey, o.endKey);
            if (retCode != 0) {
                return retCode;
            }
            if (this.address == null && o.address != null) {
                return -1;
            }
            if (this.address != null && o.address == null) {
                return 1;
            }
            if (this.address == null && o.address == null) {
                return 0;
            }
            return this.address.compareTo(o.address);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Location && this.compareTo((Location)o) == 0;
        }

        public byte[] getBytes() throws IOException {
            return LindormObjectUtils.getBytes(this);
        }

        public static Location fromBytes(byte[] bytes) throws IOException {
            Location location = new Location();
            LindormObjectUtils.getWritable(bytes, location);
            return location;
        }
    }

    public static class LocationList
    extends VersionedObjectWithAttributes {
        private List<Location> locations;

        public LocationList(List<Location> locations) {
            this.locations = locations;
        }

        public LocationList() {
        }

        public void addLocation(Location location) {
            if (this.locations == null) {
                this.locations = new ArrayList<Location>();
            }
            this.locations.add(location);
        }

        public void addLocations(Collection<Location> locationsToAdd) {
            if (this.locations == null) {
                this.locations = new ArrayList<Location>();
            }
            this.locations.addAll(locationsToAdd);
        }

        public int size() {
            if (this.locations == null) {
                return 0;
            }
            return this.locations.size();
        }

        public List<Location> getLocations() {
            return this.locations;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            if (this.locations == null || this.locations.size() == 0) {
                WritableUtils.writeVInt(out, 0);
            } else {
                WritableUtils.writeVInt(out, this.locations.size());
                for (Location location : this.locations) {
                    location.writeTo(out);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            super.readFrom(in);
            this.locations = new ArrayList<Location>();
            int size = WritableUtils.readVInt(in);
            for (int i = 0; i < size; ++i) {
                Location location = new Location();
                location.readFrom(in);
                this.locations.add(location);
            }
        }

        public byte[] getBytes() throws IOException {
            return WritableUtils.getBytes(this);
        }

        public static LocationList fromBytes(byte[] bytes) throws IOException {
            LocationList locationList = new LocationList();
            WritableUtils.getWritable(bytes, locationList);
            return locationList;
        }
    }
}

