/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.core.AsyncDDLType;
import com.alibaba.lindorm.client.core.ipc.DynamicConfig;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.client.core.ipc.LindormTableInfo;
import com.alibaba.lindorm.client.core.ipc.LocationCache;
import com.alibaba.lindorm.client.core.ipc.SyncState;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.ExternalIndexConfig;
import com.alibaba.lindorm.client.core.meta.ExternalIndexField;
import com.alibaba.lindorm.client.core.meta.LDRegionLocation;
import com.alibaba.lindorm.client.core.meta.TableCategory;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.meta.TableState;
import com.alibaba.lindorm.client.core.metrics.PassiveMetrics;
import com.alibaba.lindorm.client.core.search.SearchFileType;
import com.alibaba.lindorm.client.core.tableservice.LAggregate;
import com.alibaba.lindorm.client.core.tableservice.LAggregateResult;
import com.alibaba.lindorm.client.core.tableservice.LAppend;
import com.alibaba.lindorm.client.core.tableservice.LDelete;
import com.alibaba.lindorm.client.core.tableservice.LIncrease;
import com.alibaba.lindorm.client.core.tableservice.LIndexDescriptor;
import com.alibaba.lindorm.client.core.tableservice.LModifyTableRequest;
import com.alibaba.lindorm.client.core.tableservice.LMutationResult;
import com.alibaba.lindorm.client.core.tableservice.LQueryResults;
import com.alibaba.lindorm.client.core.tableservice.LSelect;
import com.alibaba.lindorm.client.core.tableservice.LUpsert;
import com.alibaba.lindorm.client.core.tableservice.index.IndexList;
import com.alibaba.lindorm.client.core.tableservice.index.LSearchIndexDescriptor;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ReflectionUtils;
import com.alibaba.lindorm.client.core.utils.Text;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WAppend;
import com.alibaba.lindorm.client.core.widecolumnservice.WDelete;
import com.alibaba.lindorm.client.core.widecolumnservice.WExec;
import com.alibaba.lindorm.client.core.widecolumnservice.WExecResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WGet;
import com.alibaba.lindorm.client.core.widecolumnservice.WIncrement;
import com.alibaba.lindorm.client.core.widecolumnservice.WMutationResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WOperation;
import com.alibaba.lindorm.client.core.widecolumnservice.WPartialResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WPut;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WRowMutations;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBinaryComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBinaryPrefixComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBitComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WNullComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WRegexStringComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WSubstringComparator;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.exporter.ExporterConsumer;
import com.alibaba.lindorm.client.exporter.ExporterLogFile;
import com.alibaba.lindorm.client.exporter.FileSystemInfo;
import com.alibaba.lindorm.client.quota.PrefetchQuotaRequest;
import com.alibaba.lindorm.client.quota.QuotaConfig;
import com.alibaba.lindorm.client.quota.QuotaLevel;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.LindormTableInfoOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LindormRawObject
implements LindormObject {
    protected static final Log LOG = LogFactory.getLog(LindormRawObject.class);
    private static final boolean NOT_ENCODED_CLASS_ENABLED = true;
    static final Map<Integer, Class<?>> CODE_TO_CLASS = new HashMap();
    static final Map<Class<?>, Integer> CLASS_TO_CODE = new HashMap();
    private static final byte NOT_ENCODED = 0;
    private static final int GENERIC_ARRAY_CODE;
    private static final int NEXT_CLASS_CODE;
    private Class<?> declaredClass;
    private Object instance;

    public LindormRawObject() {
    }

    public LindormRawObject(Object instance) {
        this.set(instance);
    }

    public LindormRawObject(Class<?> declaredClass, Object instance) {
        this.declaredClass = declaredClass;
        this.instance = instance;
    }

    public Object get() {
        return this.instance;
    }

    public Class<?> getDeclaredClass() {
        return this.declaredClass;
    }

    public void set(Object instance) {
        this.declaredClass = instance.getClass();
        this.instance = instance;
    }

    public String toString() {
        return "OW[class=" + this.declaredClass + ",value=" + this.instance + "]";
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        LindormRawObject.readObject(in, this);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        LindormRawObject.writeObject(out, this.instance, this.declaredClass);
    }

    public long getWritableSize() {
        return LindormRawObject.getWritableSize(this.instance, this.declaredClass);
    }

    static Integer getClassCode(Class<?> c) throws IOException {
        Integer code = CLASS_TO_CODE.get(c);
        if (code == null) {
            if (List.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(List.class);
            } else if (LindormObject.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(LindormObject.class);
            } else if (c.isArray()) {
                code = CLASS_TO_CODE.get(Array.class);
            } else if (Serializable.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(Serializable.class);
            }
        }
        return code;
    }

    static int getNextClassCode() {
        return NEXT_CLASS_CODE;
    }

    static void writeClassCode(DataOutput out, Class<?> c) throws IOException {
        Integer code = LindormRawObject.getClassCode(c);
        if (code == null) {
            LindormRawObject.throwUnsupportedTypeException(c);
        }
        WritableUtils.writeVInt(out, code);
    }

    static void throwUnsupportedTypeException(Class<?> c) {
        StackTraceElement[] els;
        LOG.error((Object)("Unsupported type " + c));
        for (StackTraceElement elem : els = new Exception().getStackTrace()) {
            LOG.error((Object)elem.getMethodName());
        }
        throw new UnsupportedOperationException("No code for unexpected " + c);
    }

    public static long getWritableSize(Object instance, Class declaredClass) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(DataOutput out, Object instance, Class declaredClass) throws IOException {
        Object instanceObj = instance;
        Class<LindormObject> declClass = declaredClass;
        if (instanceObj == null) {
            instanceObj = new NullInstance(declClass);
            declClass = LindormObject.class;
        }
        LindormRawObject.writeClassCode(out, declClass);
        if (declClass.isArray()) {
            if (declClass.equals(byte[].class)) {
                Bytes.writeByteArray(out, (byte[])instanceObj);
            } else {
                if (LindormRawObject.getClassCode(declaredClass) == GENERIC_ARRAY_CODE) {
                    Class<?> componentType = declaredClass.getComponentType();
                    LindormRawObject.writeClass(out, componentType);
                }
                int length = Array.getLength(instanceObj);
                out.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(instanceObj, i);
                    LindormRawObject.writeObject(out, item, item.getClass());
                }
            }
        } else if (List.class.isAssignableFrom(declClass)) {
            List list = (List)instanceObj;
            int length = list.size();
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                Object elem;
                LindormRawObject.writeObject(out, elem, (elem = list.get(i)) == null ? LindormObject.class : elem.getClass());
            }
        } else if (declClass == String.class) {
            Text.writeString(out, (String)instanceObj);
        } else if (declClass.isPrimitive()) {
            if (declClass == Boolean.TYPE) {
                out.writeBoolean((Boolean)instanceObj);
            } else if (declClass == Character.TYPE) {
                out.writeChar(((Character)instanceObj).charValue());
            } else if (declClass == Byte.TYPE) {
                out.writeByte(((Byte)instanceObj).byteValue());
            } else if (declClass == Short.TYPE) {
                out.writeShort(((Short)instanceObj).shortValue());
            } else if (declClass == Integer.TYPE) {
                out.writeInt((Integer)instanceObj);
            } else if (declClass == Long.TYPE) {
                out.writeLong((Long)instanceObj);
            } else if (declClass == Float.TYPE) {
                out.writeFloat(((Float)instanceObj).floatValue());
            } else if (declClass == Double.TYPE) {
                out.writeDouble((Double)instanceObj);
            } else if (declClass != Void.TYPE) {
                throw new IllegalArgumentException("Not a primitive: " + declClass);
            }
        } else if (declClass.isEnum()) {
            Text.writeString(out, ((Enum)instanceObj).name());
        } else if (LindormObject.class.isAssignableFrom(declClass)) {
            Class<?> c = instanceObj.getClass();
            Integer code = CLASS_TO_CODE.get(c);
            if (code == null) {
                out.writeByte(0);
                Text.writeString(out, c.getName());
            } else {
                LindormRawObject.writeClassCode(out, c);
            }
            ((LindormObject)instanceObj).writeTo(out);
        } else if (Serializable.class.isAssignableFrom(declClass)) {
            Class<?> c = instanceObj.getClass();
            Integer code = CLASS_TO_CODE.get(c);
            if (code == null) {
                out.writeByte(0);
                Text.writeString(out, c.getName());
            } else {
                LindormRawObject.writeClassCode(out, c);
            }
            ByteArrayOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(instanceObj);
                byte[] value = bos.toByteArray();
                out.writeInt(value.length);
                out.write(value);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
        } else {
            throw new IOException("Can't writeTo: " + instanceObj + " as " + declClass);
        }
    }

    static void writeClass(DataOutput out, Class<?> c) throws IOException {
        Integer code = CLASS_TO_CODE.get(c);
        if (code == null) {
            WritableUtils.writeVInt(out, 0);
            Text.writeString(out, c.getName());
        } else {
            WritableUtils.writeVInt(out, code);
        }
    }

    static Class<?> readClass(DataInput in) throws IOException {
        Class instanceClass = null;
        byte b = (byte)WritableUtils.readVInt(in);
        if (b == 0) {
            String className = Text.readString(in);
            try {
                instanceClass = LindormRawObject.getClassByName(className);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Can't find class " + className), (Throwable)e);
                throw new IOException("Can't find class " + className, e);
            }
        } else {
            instanceClass = CODE_TO_CLASS.get(b);
        }
        return instanceClass;
    }

    public static Object readObject(DataInput in) throws IOException {
        return LindormRawObject.readObject(in, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object readObject(DataInput in, LindormRawObject objectWritable) throws IOException {
        Object instance;
        int classCode = WritableUtils.readVInt(in);
        Class<?> declaredClass = CODE_TO_CLASS.get(classCode);
        if (declaredClass == null) {
            LOG.error((Object)("Can't find class of code " + classCode));
            throw new IOException("Can't find class of code " + classCode);
        }
        if (declaredClass.isPrimitive()) {
            if (declaredClass == Boolean.TYPE) {
                instance = in.readBoolean();
            } else if (declaredClass == Character.TYPE) {
                instance = Character.valueOf(in.readChar());
            } else if (declaredClass == Byte.TYPE) {
                instance = in.readByte();
            } else if (declaredClass == Short.TYPE) {
                instance = in.readShort();
            } else if (declaredClass == Integer.TYPE) {
                instance = in.readInt();
            } else if (declaredClass == Long.TYPE) {
                instance = in.readLong();
            } else if (declaredClass == Float.TYPE) {
                instance = Float.valueOf(in.readFloat());
            } else if (declaredClass == Double.TYPE) {
                instance = in.readDouble();
            } else {
                if (declaredClass != Void.TYPE) throw new IllegalArgumentException("Not a primitive: " + declaredClass);
                instance = null;
            }
        } else if (declaredClass.isArray()) {
            if (declaredClass.equals(byte[].class)) {
                instance = Bytes.readByteArray(in);
            } else {
                int length = in.readInt();
                instance = Array.newInstance(declaredClass.getComponentType(), length);
                for (int i = 0; i < length; ++i) {
                    Array.set(instance, i, LindormRawObject.readObject(in));
                }
            }
        } else if (declaredClass.equals(Array.class)) {
            Class<?> componentType = LindormRawObject.readClass(in);
            int length = in.readInt();
            instance = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(instance, i, LindormRawObject.readObject(in));
            }
        } else if (List.class.isAssignableFrom(declaredClass)) {
            int length = in.readInt();
            instance = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                ((ArrayList)instance).add(LindormRawObject.readObject(in));
            }
        } else if (declaredClass == String.class) {
            instance = Text.readString(in);
        } else if (declaredClass.isEnum()) {
            instance = Enum.valueOf(declaredClass, Text.readString(in));
        } else {
            Class instanceClass = null;
            int b = WritableUtils.readVInt(in);
            if (b == 0) {
                String className = Text.readString(in);
                try {
                    instanceClass = LindormRawObject.getClassByName(className);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)("Can't find class " + className), (Throwable)e);
                    throw new IOException("Can't find class " + className, e);
                }
            } else {
                instanceClass = CODE_TO_CLASS.get(b);
            }
            if (LindormObject.class.isAssignableFrom(instanceClass)) {
                LindormObject writable = (LindormObject)ReflectionUtils.newInstance(instanceClass);
                try {
                    writable.readFrom(in);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error in readFrom", (Throwable)e);
                    throw new IOException("Error in readFrom", e);
                }
                instance = writable;
                if (instanceClass == NullInstance.class) {
                    declaredClass = ((NullInstance)instance).declaredClass;
                    instance = null;
                }
            } else {
                int length = in.readInt();
                byte[] objectBytes = new byte[length];
                in.readFully(objectBytes);
                ByteArrayInputStream bis = null;
                ObjectInputStream ois = null;
                try {
                    bis = new ByteArrayInputStream(objectBytes);
                    ois = new ObjectInputStream(bis);
                    instance = ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)"Class not found when attempting to deserialize object", (Throwable)e);
                    throw new IOException("Class not found when attempting to deserialize object", e);
                }
                finally {
                    if (bis != null) {
                        bis.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
            }
        }
        if (objectWritable == null) return instance;
        objectWritable.declaredClass = declaredClass;
        objectWritable.instance = instance;
        return instance;
    }

    private static Class getClassByName(String className) throws ClassNotFoundException {
        ClassLoader cl = LindormRawObject.class.getClassLoader();
        return Class.forName(className, true, cl);
    }

    private static void addToMap(Class<?> clazz, int code) {
        if (CODE_TO_CLASS.containsKey(code)) {
            throw new RuntimeException("code " + code + " is already in map CODE_TO_CLASS");
        }
        CODE_TO_CLASS.put(code, clazz);
        CLASS_TO_CODE.put(clazz, code);
    }

    static {
        LindormRawObject.addToMap(Boolean.TYPE, 1);
        LindormRawObject.addToMap(Byte.TYPE, 2);
        LindormRawObject.addToMap(Character.TYPE, 3);
        LindormRawObject.addToMap(Short.TYPE, 4);
        LindormRawObject.addToMap(Integer.TYPE, 5);
        LindormRawObject.addToMap(Long.TYPE, 6);
        LindormRawObject.addToMap(Float.TYPE, 7);
        LindormRawObject.addToMap(Double.TYPE, 8);
        LindormRawObject.addToMap(Void.TYPE, 9);
        LindormRawObject.addToMap(String.class, 10);
        LindormRawObject.addToMap(byte[].class, 11);
        LindormRawObject.addToMap(byte[][].class, 12);
        LindormRawObject.addToMap(Text.class, 13);
        LindormRawObject.addToMap(LindormObject.class, 14);
        LindormRawObject.addToMap(LindormObject[].class, 15);
        LindormRawObject.addToMap(NullInstance.class, 17);
        LindormRawObject.addToMap(List.class, 61);
        LindormRawObject.addToMap(NavigableSet.class, 62);
        LindormRawObject.addToMap(Serializable.class, 71);
        LindormRawObject.addToMap(TableMeta.class, 87);
        LindormRawObject.addToMap(LSelect.class, 88);
        LindormRawObject.addToMap(LUpsert.class, 89);
        LindormRawObject.addToMap(LDelete.class, 90);
        LindormRawObject.addToMap(LQueryResults.PartialResult.class, 91);
        LindormRawObject.addToMap(LMutationResult.class, 92);
        LindormRawObject.addToMap(LDServerAddress.class, 98);
        LindormRawObject.addToMap(LocationCache.Location.class, 99);
        LindormRawObject.addToMap(AsyncDDLType.class, 100);
        LindormRawObject.addToMap(VersionedObjectWithAttributes.class, 101);
        LindormRawObject.addToMap(DynamicConfig.class, 102);
        GENERIC_ARRAY_CODE = 81;
        LindormRawObject.addToMap(Array.class, GENERIC_ARRAY_CODE);
        LindormRawObject.addToMap(LIncrease.class, 108);
        LindormRawObject.addToMap(LAppend.class, 111);
        LindormRawObject.addToMap(LAggregate.class, 113);
        LindormRawObject.addToMap(LAggregateResult.class, 114);
        LindormRawObject.addToMap(ExporterLogFile.class, 118);
        LindormRawObject.addToMap(FileSystemInfo.class, 120);
        LindormRawObject.addToMap(ExporterConsumer.class, 121);
        LindormRawObject.addToMap(TableState.class, 122);
        LindormRawObject.addToMap(WBinaryComparator.class, 125);
        LindormRawObject.addToMap(WBinaryPrefixComparator.class, 126);
        LindormRawObject.addToMap(WBitComparator.class, 127);
        LindormRawObject.addToMap(WNullComparator.class, 128);
        LindormRawObject.addToMap(WRegexStringComparator.class, 129);
        LindormRawObject.addToMap(WSubstringComparator.class, 130);
        LindormRawObject.addToMap(WOperation.class, 131);
        LindormRawObject.addToMap(WAppend.class, 132);
        LindormRawObject.addToMap(WDelete.class, 133);
        LindormRawObject.addToMap(WGet.class, 134);
        LindormRawObject.addToMap(WIncrement.class, 135);
        LindormRawObject.addToMap(WMutationResult.class, 136);
        LindormRawObject.addToMap(WPartialResult.class, 137);
        LindormRawObject.addToMap(WPut.class, 138);
        LindormRawObject.addToMap(WScan.class, 139);
        LindormRawObject.addToMap(LDRegionLocation.class, 140);
        LindormRawObject.addToMap(LIndexDescriptor.class, 141);
        LindormRawObject.addToMap(WResult.class, 142);
        LindormRawObject.addToMap(SyncState.class, 143);
        LindormRawObject.addToMap(IndexState.class, 144);
        LindormRawObject.addToMap(LModifyTableRequest.class, 149);
        LindormRawObject.addToMap(TableCategory.class, 150);
        LindormRawObject.addToMap(LindormTableInfo.class, 151);
        LindormRawObject.addToMap(PassiveMetrics.PassiveMetricsSnapshot.class, 152);
        LindormRawObject.addToMap(QuotaLevel.class, 153);
        LindormRawObject.addToMap(QuotaConfig.class, 154);
        LindormRawObject.addToMap(PrefetchQuotaRequest.class, 155);
        LindormRawObject.addToMap(WCompareFilter.CompareOp.class, 160);
        LindormRawObject.addToMap(WRowMutations.class, 161);
        LindormRawObject.addToMap(ExternalIndexField.class, 162);
        LindormRawObject.addToMap(ExternalIndexConfig.class, 163);
        LindormRawObject.addToMap(WExec.class, 164);
        LindormRawObject.addToMap(WExecResult.class, 165);
        LindormRawObject.addToMap(LSearchIndexDescriptor.class, 172);
        LindormRawObject.addToMap(ColumnKey.class, 173);
        LindormRawObject.addToMap(IndexList.class, 174);
        LindormRawObject.addToMap(LindormTableInfoOptions.class, 175);
        LindormRawObject.addToMap(SearchFileType.class, 176);
        NEXT_CLASS_CODE = 177;
    }

    private static class NullInstance
    implements LindormObject {
        Class<?> declaredClass;

        public NullInstance() {
        }

        public NullInstance(Class<?> declaredClass) {
            this.declaredClass = declaredClass;
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.declaredClass = CODE_TO_CLASS.get(WritableUtils.readVInt(in));
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            LindormRawObject.writeClassCode(out, this.declaredClass);
        }
    }
}

