/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.feedstreamservice;

import com.alibaba.lindorm.client.core.feedstreamservice.LMessage;
import com.alibaba.lindorm.client.core.utils.FeedStreamUtils;
import com.alibaba.lindorm.client.dml.QueryResults;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LMessageScanner
implements Iterable<LMessage> {
    private QueryResults results;
    private String streamName;

    public LMessageScanner(QueryResults results, String streamName) {
        this.results = results;
        this.streamName = streamName;
    }

    @Override
    public Iterator<LMessage> iterator() {
        return new Iterator<LMessage>(){
            private Iterator<Row> itor;
            {
                this.itor = LMessageScanner.this.results.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itor.hasNext();
            }

            @Override
            public LMessage next() {
                try {
                    Row r = this.itor.next();
                    if (r != null) {
                        return FeedStreamUtils.rowToMessage(LMessageScanner.this.streamName, r);
                    }
                    return null;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public LMessage next() throws LindormException {
        Row r = this.results.next();
        if (r != null) {
            return FeedStreamUtils.rowToMessage(this.streamName, r);
        }
        return null;
    }

    public List<LMessage> next(int maxNumberOfMessages) throws LindormException {
        if (maxNumberOfMessages < 1) {
            throw new IllegalRequestException("maxNumberOfMessages must >= 1, but has " + maxNumberOfMessages);
        }
        ArrayList<LMessage> messages = new ArrayList<LMessage>(maxNumberOfMessages);
        for (Row r : this.results.next(maxNumberOfMessages)) {
            messages.add(FeedStreamUtils.rowToMessage(this.streamName, r));
        }
        return messages;
    }
}

