/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.expression.SimilarityExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.SimpleConditionParser;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;

public class LikeExpression
extends SimilarityExpression {
    public LikeExpression() {
    }

    public LikeExpression(byte[] columnName, String pattern) {
        super(columnName, pattern);
    }

    public LikeExpression(byte[] columnName, String pattern, Character escapeCharacter) {
        super(columnName, pattern, escapeCharacter);
    }

    public LikeExpression(byte[] family, byte[] columnName, String pattern) {
        super(family, columnName, pattern);
    }

    public LikeExpression(byte[] family, byte[] columnName, String pattern, Character escapeCharacter) {
        super(family, columnName, pattern, escapeCharacter);
    }

    public LikeExpression(LColumn column, String pattern, Character escapeCharacter) {
        super(column, pattern, escapeCharacter);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public String toParseableString() {
        return this.toString();
    }

    @Override
    protected String getName() {
        return "LIKE";
    }

    @Override
    protected boolean getExpectedResult() {
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LikeExpression)) {
            return false;
        }
        LikeExpression other = (LikeExpression)obj;
        if (!this.columnKey.equals(other.columnKey)) {
            return false;
        }
        if (!this.pattern.equals(other.pattern)) {
            return false;
        }
        return this.escapeCharacter == null ? other.escapeCharacter == null : this.escapeCharacter.equals(other.escapeCharacter);
    }

    @Override
    public String toString() {
        return "(" + this.columnKey.getFullNameAsString() + " LIKE " + this.pattern + (this.escapeCharacter == null ? "" : " ESCAPE " + this.escapeCharacter) + ")";
    }

    public static Condition createConditionFromArguments(ArrayList<byte[]> conditionArguments) {
        SimpleConditionParser.similarityCheck(conditionArguments);
        byte[] columnName = SimpleConditionParser.getSimilarityColumnName(conditionArguments);
        byte[] patternBytes = SimpleConditionParser.getSimilarityPattern(conditionArguments);
        Character escapeCharacter = SimpleConditionParser.getSimilarityEscapeCharacter(conditionArguments);
        String columnStr = Bytes.toString(columnName);
        if (columnStr.contains(SchemaUtils.COLUMN_NAME_SEPARATOR)) {
            return new LikeExpression(Bytes.toBytes(columnStr.split(SchemaUtils.COLUMN_NAME_SEPARATOR)[0]), Bytes.toBytes(columnStr.split(SchemaUtils.COLUMN_NAME_SEPARATOR)[1]), Bytes.toString(patternBytes), escapeCharacter);
        }
        return new LikeExpression(columnName, Bytes.toString(patternBytes), escapeCharacter);
    }
}

