/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.SimpleConditionParser;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;

public class ComparisonExpression
extends Condition {
    private static LDataTypeFactory TYPE_FACTORY = LDataTypeFactory.INSTANCE;
    private static final String DECIMAL_NATIVE_ENCODING_BYTES = "DECIMAL_NATIVE_ENCODING_BYTES";
    private ColumnKey columnKey;
    private ConditionFactory.CompareOp op;
    private DataType type;
    private Object value;
    private LColumn column = null;
    private byte[] rhs = null;

    public ComparisonExpression() {
    }

    public ComparisonExpression(byte[] columnName, ConditionFactory.CompareOp op, Object value) throws LindormException {
        this(null, columnName, op, value);
    }

    public ComparisonExpression(ColumnValue columnValue, ConditionFactory.CompareOp op) throws LindormException {
        this(columnValue.getFamilyName(), columnValue.getColumnName(), op, columnValue.getValueObject());
    }

    public ComparisonExpression(byte[] familyName, byte[] columnName, ConditionFactory.CompareOp op, Object value) throws LindormException {
        this.columnKey = new ColumnKey(familyName, columnName);
        this.op = op;
        this.value = value;
        if (ConditionFactory.CompareOp.isNullValueOp(op)) {
            if (value != null) {
                throw new IllegalDataException("Comparison with not null value is not supported. expr=" + this.toString());
            }
            this.type = DataType.VARBINARY;
        } else {
            if (value == null) {
                throw new IllegalDataException("Comparison with null value is not supported. expr=" + this.toString());
            }
            this.type = TYPE_FACTORY.getTypeByClass(value.getClass()).getClientType();
        }
    }

    public ComparisonExpression(LColumn column, ConditionFactory.CompareOp op, byte[] value) throws IllegalDataException {
        this.columnKey = column.getColumnKey();
        this.op = op;
        this.type = column.getDataType().getClientType();
        if (ConditionFactory.CompareOp.isNullValueOp(op)) {
            if (value != null) {
                throw new IllegalDataException("Comparison with not null value is not supported. expr=" + this.toString());
            }
            this.value = null;
        } else {
            this.value = LDataType.toObject(column, value);
            if (this.value == null) {
                throw new IllegalDataException("Comparison with null value is not supported. expr=" + this.toString());
            }
        }
        this.column = column;
        this.rhs = value;
    }

    public ComparisonExpression shallowCopy(ColumnKey newColumnKey) {
        ComparisonExpression ret = new ComparisonExpression();
        ret.columnKey = newColumnKey != null ? newColumnKey : this.columnKey;
        ret.op = this.op;
        ret.type = this.type;
        ret.value = this.value;
        ret.column = this.column;
        return ret;
    }

    public byte[] getColumnFullName() {
        return this.columnKey.getFullName();
    }

    public ColumnKey getColumnKey() {
        return this.columnKey;
    }

    public Object getValue() {
        return this.value;
    }

    public DataType getDataType() {
        return this.type;
    }

    public ConditionFactory.CompareOp getOp() {
        return this.op;
    }

    public LColumn getColumnMeta() {
        return this.column;
    }

    public void setColumnMeta(LColumn column) {
        this.column = column;
    }

    public byte[] evaluateRHS(LColumn columnMeta) throws IllegalDataException {
        if (this.rhs == null) {
            this.rhs = LDataType.toBytes(columnMeta, this.value, TYPE_FACTORY.getTypeInstance(this.type));
        }
        return this.rhs;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        assert (this.column != null);
        try {
            ImmutableBytesPtr ptr = new ImmutableBytesPtr();
            if (this.column.isPrimaryKey()) {
                tuple.getPrimaryKeys().getPKValue(this.column.getPosition(), ptr);
                if (SchemaUtils.storePkNulls(this.column)) {
                    if (ptr.getLength() == 0 || SchemaUtils.isNullValueByte(ptr.get()[ptr.getOffset()], this.column.getSortOrder())) {
                        result.set(ConditionFactory.CompareOp.isNullValueOp(this.op) ? DataTypeUtils.TRUE_BYTES : DataTypeUtils.FALSE_BYTES);
                        return true;
                    }
                } else if (this.value == null) {
                    result.set(this.op.equals((Object)ConditionFactory.CompareOp.IS_NOT) ? DataTypeUtils.TRUE_BYTES : DataTypeUtils.FALSE_BYTES);
                    return true;
                }
            } else {
                tuple.getKeyValue(this.column.getFamilyName(), this.column.getColumnName(), ptr);
                if (ptr.get() == Bytes.EMPTY_BYTE_ARRAY) {
                    return false;
                }
            }
            this.evaluateRHS(this.column);
            int length = this.rhs == null ? 0 : this.rhs.length;
            int c = Bytes.compareTo(ptr.get(), ptr.getOffset(), ptr.getLength(), this.rhs, 0, length);
            ConditionFactory.CompareOp transformedOp = CompilerUtils.transformCompareOp(this.column.getSortOrder(), this.op);
            boolean ret = CompilerUtils.compare(transformedOp, c, ptr.getLength() == 0);
            result.set(ret ? DataTypeUtils.TRUE_BYTES : DataTypeUtils.FALSE_BYTES);
            return true;
        }
        catch (Throwable t) {
            throw new LindormException("Failed evaluating " + this.toString(), t);
        }
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetAll() {
        this.column = null;
        this.rhs = null;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.writeNativeBytesOfDecimalToAttributes();
        super.writeTo(out);
        this.columnKey.writeTo(out);
        WritableUtils.writeVInt(out, this.op.ordinal());
        WritableUtils.writeVInt(out, this.type.ordinal());
        if (!ConditionFactory.CompareOp.isNullValueOp(this.op)) {
            LDataType typeInstance = LDataTypeFactory.INSTANCE.getTypeInstance(this.type);
            byte[] valueBytes = typeInstance.toBytes(this.value);
            if (valueBytes.length > 0x200000) {
                throw new IllegalRequestException("Right operand for " + this.getBrief() + " is too big, max length is " + 0x200000 + ", but has " + valueBytes.length);
            }
            Bytes.writeByteArray(out, valueBytes);
        }
        if (this.column != null) {
            WritableUtils.writeVInt(out, 1);
            this.column.writeTo(out);
        } else {
            WritableUtils.writeVInt(out, 0);
        }
    }

    private void writeNativeBytesOfDecimalToAttributes() throws IllegalRequestException {
        if (!(ConditionFactory.CompareOp.isNullValueOp(this.op) || this.type != DataType.DECIMAL && this.type != DataType.DECIMAL_V2)) {
            byte[] valueBytes = Bytes.toBytes((BigDecimal)this.value);
            if (valueBytes.length > 0x200000) {
                throw new IllegalRequestException("Right operand for " + this.getBrief() + " is too big, max length is " + 0x200000 + ", but has " + valueBytes.length);
            }
            this.attributes.put(DECIMAL_NATIVE_ENCODING_BYTES, valueBytes);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        int hasColumnMeta;
        super.readFrom(in);
        this.columnKey = new ColumnKey();
        this.columnKey.readFrom(in);
        this.op = ConditionFactory.CompareOp.values()[WritableUtils.readVInt(in)];
        int typeOrdinal = WritableUtils.readVInt(in);
        this.type = LDataTypeFactory.INSTANCE.getClientTypeByOrdinal(typeOrdinal);
        if (!ConditionFactory.CompareOp.isNullValueOp(this.op)) {
            byte[] valueBytes = Bytes.readByteArray(in);
            if (this.type == DataType.DECIMAL && this.attributes.containsKey(DECIMAL_NATIVE_ENCODING_BYTES)) {
                this.value = Bytes.toBigDecimal((byte[])this.attributes.get(DECIMAL_NATIVE_ENCODING_BYTES));
            } else {
                LDataType typeInstance = LDataTypeFactory.INSTANCE.getTypeInstance(this.type);
                this.value = typeInstance.toObject(valueBytes);
            }
        }
        if ((hasColumnMeta = WritableUtils.readVInt(in)) != 0) {
            this.column = new LColumn();
            this.column.readFrom(in);
        }
    }

    private String getBrief() {
        return "(" + this.columnKey.getFullNameAsString() + " " + SchemaUtils.getReadableOperator(this.op) + " ...)";
    }

    @Override
    public String toString() {
        return "(" + this.columnKey.getFullNameAsString() + " " + SchemaUtils.getReadableOperator(this.op) + " " + (this.type != null ? DataTypeUtils.valueToString(this.type, this.value) : this.value) + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ComparisonExpression)) {
            return false;
        }
        ComparisonExpression other = (ComparisonExpression)obj;
        if (!this.columnKey.equals(other.columnKey)) {
            return false;
        }
        if (this.op != other.op) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        if (this.value instanceof byte[]) {
            return other.value instanceof byte[] && Bytes.equals((byte[])this.value, (byte[])other.value);
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.op.hashCode();
        if (this.value != null) {
            result = 31 * result + this.value.hashCode();
        }
        result = 31 * result + this.columnKey.hashCode();
        return result;
    }

    public static Condition createConditionFromArguments(ArrayList<byte[]> conditionArguments) throws LindormException {
        String columnStr;
        int size = conditionArguments.size();
        Preconditions.checkArgument(size == 3 || size == 4, "Expected 3 or 4 but got: %s", conditionArguments.size());
        boolean hasQuotes = SimpleConditionParser.hasQuotesOnByteArray(conditionArguments.get(0));
        byte[] columnName = hasQuotes ? SimpleConditionParser.removeQuotesFromByteArray(conditionArguments.get(0)) : conditionArguments.get(0);
        ConditionFactory.CompareOp compareOp = size == 3 ? SimpleConditionParser.createCompareOp(conditionArguments.get(1)) : ConditionFactory.CompareOp.IS_NOT;
        byte[] lastArgument = conditionArguments.get(size - 1);
        Object columnValue = null;
        if (!ConditionFactory.CompareOp.isNullValueOp(compareOp) || Bytes.compareTo(lastArgument, Bytes.toBytes("null")) != 0) {
            columnValue = SimpleConditionParser.hasQuotesOnByteArray(lastArgument) ? Bytes.toString(SimpleConditionParser.removeQuotesFromByteArray(lastArgument)) : (SimpleConditionParser.isBooleanByteArray(lastArgument) ? Boolean.valueOf(SimpleConditionParser.convertByteArrayToBoolean(lastArgument)) : SimpleConditionParser.convertByteArrayToNumberOrString(lastArgument));
        }
        if ((columnStr = Bytes.toString(columnName)).indexOf(SchemaUtils.COLUMN_NAME_SEPARATOR) != -1) {
            return new ComparisonExpression(Bytes.toBytes(columnStr.split(SchemaUtils.COLUMN_NAME_SEPARATOR)[0]), Bytes.toBytes(columnStr.split(SchemaUtils.COLUMN_NAME_SEPARATOR)[1]), compareOp, columnValue);
        }
        return new ComparisonExpression(columnName, compareOp, columnValue);
    }

    @Override
    public String toParseableString() {
        return "EXP('" + Bytes.toString(this.getColumnFullName()) + "' " + Bytes.toString(SimpleConditionParser.convertCompareOpToByteArray(this.getOp())) + " " + this.getValueAsString() + ")";
    }

    public String getValueAsString() {
        if (this.getValue() == null) {
            return "null";
        }
        switch (this.type) {
            case STRING: {
                return "'" + this.getValue() + "'";
            }
        }
        return this.getValue().toString();
    }
}

