/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.command;

import com.alibaba.lindorm.client.core.command.Command;
import com.alibaba.lindorm.client.core.command.CommandResult;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.metrics.OperationMetricsSnapshot;
import com.alibaba.lindorm.client.core.metrics.TableMetrics;
import com.alibaba.lindorm.client.core.metrics.TableMetricsManager;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GetMetricsCommand
extends Command {
    private static Command.Type type = Command.Type.GETMETRIC;
    private static String BEGIN = "BEGIN";
    private static String END = "END";
    String namespace;
    String table;
    int recordTime;
    int maxErrorToKeep;
    List<OperationContext.OperationType> operationTypes;

    public GetMetricsCommand() {
    }

    public GetMetricsCommand(String namespace, String table, List<OperationContext.OperationType> operationTypes, int recordTime) {
        this.namespace = namespace;
        this.table = table;
        this.operationTypes = operationTypes;
        this.recordTime = recordTime;
    }

    public GetMetricsCommand(String namespace, String table, List<OperationContext.OperationType> operationTypes, long begin, long end) {
        this.namespace = namespace;
        this.table = table;
        this.operationTypes = operationTypes;
        this.recordTime = 0;
        this.setAttribute(BEGIN, Bytes.toBytes(begin));
        this.setAttribute(END, Bytes.toBytes(end));
    }

    public long getTimeBegin() {
        if (this.hasAttribute(BEGIN)) {
            return Bytes.toLong(this.getAttribute("BEGIN"));
        }
        return 0L;
    }

    public long getTimeEnd() {
        if (this.hasAttribute(END)) {
            return Bytes.toLong(this.getAttribute("END"));
        }
        return 0L;
    }

    public GetMetricsCommand(String namespace, String table, int recordTime) {
        this(namespace, table, TableMetricsManager.RWTYPES, recordTime);
    }

    public GetMetricsCommand(String namespace, String table, long begin, long end) {
        this(namespace, table, TableMetricsManager.RWTYPES, begin, end);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTable() {
        return this.table;
    }

    public int getRecordTime() {
        return this.recordTime;
    }

    public List<OperationContext.OperationType> getOperationTypes() {
        return this.operationTypes;
    }

    @Override
    public Command.Type getType() {
        return type;
    }

    @Override
    public CommandResult run(LConnection lConnection) {
        try {
            TableMetricsManager tableMetricsManager;
            long startTime = this.getTimeBegin();
            long endTime = this.getTimeEnd();
            String result = null;
            if (this.recordTime > 0) {
                endTime = System.currentTimeMillis();
                startTime = endTime - (long)this.recordTime;
            }
            if ((tableMetricsManager = lConnection.getTableMetricsManager()).hasTableMetrics(this.namespace, this.table)) {
                TableMetrics tableMetrics = tableMetricsManager.getTableMetrics(this.namespace, this.table);
                StringBuilder sb = new StringBuilder(1024);
                sb.append("Namespace: ").append(this.namespace).append(" Table: ").append(this.table).append("\n Begin:").append(new Date(startTime)).append(" End:").append(new Date(endTime)).append("\n");
                for (OperationContext.OperationType type : this.operationTypes) {
                    List<OperationMetricsSnapshot> snapshots = tableMetrics.getSnapshotInRange(type, startTime, endTime);
                    if (snapshots == null || snapshots.size() == 0) {
                        sb.append("No ops for operation Type: ").append((Object)type).append("\n");
                        continue;
                    }
                    sb.append("[Operation Type: ").append((Object)type).append("]\n");
                    long start = Long.MAX_VALUE;
                    long end = 0L;
                    long totalRowCount = 0L;
                    long successOps = 0L;
                    long errorOps = 0L;
                    long sumTime = 0L;
                    long maxTime = 0L;
                    long rt0 = 0L;
                    long rt1 = 0L;
                    long rt5 = 0L;
                    long rt10 = 0L;
                    long rt50 = 0L;
                    long rt100 = 0L;
                    long rt500 = 0L;
                    long rt1000 = 0L;
                    long rt1001 = 0L;
                    for (OperationMetricsSnapshot snapshot : snapshots) {
                        if (snapshot.getStartTime() < start) {
                            start = snapshot.getStartTime();
                        }
                        if (snapshot.getEndTime() > end) {
                            end = snapshot.getEndTime();
                        }
                        totalRowCount += snapshot.getTotalRowCount();
                        successOps += snapshot.getSuccessOps();
                        errorOps += snapshot.getErrorOps();
                        sumTime += snapshot.getSumTime();
                        if (snapshot.getMaxTime() > maxTime) {
                            maxTime = snapshot.getMaxTime();
                        }
                        rt0 += snapshot.getRt0();
                        rt1 += snapshot.getRt1();
                        rt5 += snapshot.getRt5();
                        rt10 += snapshot.getRt10();
                        rt50 += snapshot.getRt50();
                        rt100 += snapshot.getRt100();
                        rt500 += snapshot.getRt500();
                        rt1000 += snapshot.getRt1000();
                        rt1001 += snapshot.getRt1001();
                    }
                    sb.append(TableMetrics.buildMetricsLog(start, end, totalRowCount, successOps, errorOps, sumTime, maxTime, rt0, rt1, rt5, rt10, rt50, rt100, rt500, rt1000, rt1001));
                }
                result = sb.toString();
            } else {
                result = "No metrics found for namespace= " + this.namespace + ", table= " + this.table;
            }
            return new CommandResult(result, type, this.commandID);
        }
        catch (Throwable t) {
            return new CommandResult("Error happend when executing" + t.getMessage(), type, this.commandID);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.table);
        WritableUtils.writeVInt(out, this.recordTime);
        WritableUtils.writeVInt(out, this.maxErrorToKeep);
        WritableUtils.writeVInt(out, this.operationTypes.size());
        for (OperationContext.OperationType type : this.operationTypes) {
            WritableUtils.writeString(out, type.toString());
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.namespace = WritableUtils.readString(in);
        this.table = WritableUtils.readString(in);
        this.recordTime = WritableUtils.readVInt(in);
        this.maxErrorToKeep = WritableUtils.readVInt(in);
        this.operationTypes = new ArrayList<OperationContext.OperationType>();
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            OperationContext.OperationType type = Enum.valueOf(OperationContext.OperationType.class, WritableUtils.readString(in));
            this.operationTypes.add(type);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("namespace= ").append(this.namespace);
        builder.append(", table= ").append(this.table);
        builder.append(", ops= ").append(this.operationTypes);
        builder.append(", recordTime= ").append(this.recordTime);
        builder.append(", timeBegin= ").append(this.getTimeBegin());
        builder.append(", timeEnd= ").append(this.getTimeEnd());
        return builder.toString();
    }
}

