/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseDirectImplFactory;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import com.alibaba.lindorm.client.SystemService;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliHBaseUEClientService
implements ClientProtos.ClientService.BlockingInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AliHBaseUEClientService.class);
    private final int rowSizeWarnThreshold;
    public static boolean isTest;
    private SystemService systemService;
    private AliHBaseUEConnection connection;

    public AliHBaseUEClientService(AliHBaseUEConnection connection) {
        AliHBaseDirectImplFactory factory = (AliHBaseDirectImplFactory)connection.getFactory();
        try {
            this.connection = connection;
            this.systemService = factory.getSystemService();
            this.rowSizeWarnThreshold = connection.getConfiguration().getInt("hbase.rpc.rows.warning.threshold", 5000);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Create systemService exception ", e);
        }
    }

    public ClientProtos.GetResponse get(RpcController rpcController, ClientProtos.GetRequest getRequest) throws ServiceException {
        throw new UnsupportedOperationException("get(rpcController,getRequest) not supported");
    }

    public ClientProtos.MutateResponse mutate(RpcController rpcController, ClientProtos.MutateRequest mutateRequest) throws ServiceException {
        throw new UnsupportedOperationException("mutate(rpcController,mutateRequest) not supported");
    }

    public ClientProtos.ScanResponse scan(RpcController rpcController, ClientProtos.ScanRequest scanRequest) throws ServiceException {
        throw new UnsupportedOperationException("scan(rpcController,scanRequest) not supported");
    }

    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController rpcController, ClientProtos.BulkLoadHFileRequest bulkLoadHFileRequest) throws ServiceException {
        this.checkBulkLoadSupported(bulkLoadHFileRequest);
        List paths = bulkLoadHFileRequest.getFamilyPathList();
        ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>(paths.size());
        for (ClientProtos.BulkLoadHFileRequest.FamilyPath fp : paths) {
            familyPaths.add(new Pair<byte[], String>(fp.getFamily().toByteArray(), fp.getPath()));
        }
        try {
            byte[][] regionInfos = HRegionInfo.parseRegionName((byte[])bulkLoadHFileRequest.getRegion().getValue().toByteArray());
            TableName tb = TableName.valueOf((byte[])regionInfos[0]);
            boolean bulkloadResult = this.systemService.bulkLoadLdFiles(this.systemService.getLConnection().getAllIDC().get(0), tb.getNamespaceAsString(), tb.getQualifierAsString(), regionInfos[1], familyPaths);
            if (!bulkloadResult) {
                throw new IOException("Bulkload region fail: " + Bytes.toStringBinary(bulkLoadHFileRequest.getRegion().getValue().toByteArray()));
            }
        }
        catch (Exception e) {
            LOG.info("BulkLoad failed, it can be retried later ", (Throwable)e);
            throw new ServiceException("BulkLoad exception ", (Throwable)e);
        }
        ClientProtos.BulkLoadHFileResponse.Builder builder = ClientProtos.BulkLoadHFileResponse.newBuilder();
        builder.setLoaded(true);
        return builder.build();
    }

    private void checkBulkLoadSupported(ClientProtos.BulkLoadHFileRequest bulkLoadHFileRequest) {
        if (bulkLoadHFileRequest.getCopyFile()) {
            throw new UnsupportedOperationException("BulkLoad with copyFile = true unsupported ");
        }
        List<String> allIdcs = this.systemService.getLConnection().getAllIDC();
        if (allIdcs.size() > 1 && !isTest) {
            throw new IllegalStateException("BulkLoad only support single idc now , current cluster idc count : " + allIdcs.size());
        }
    }

    public ClientProtos.PrepareBulkLoadResponse prepareBulkLoad(RpcController rpcController, ClientProtos.PrepareBulkLoadRequest prepareBulkLoadRequest) throws ServiceException {
        ClientProtos.PrepareBulkLoadResponse.Builder builder = ClientProtos.PrepareBulkLoadResponse.newBuilder();
        builder.setBulkToken("mock_token");
        return builder.build();
    }

    public ClientProtos.CleanupBulkLoadResponse cleanupBulkLoad(RpcController rpcController, ClientProtos.CleanupBulkLoadRequest cleanupBulkLoadRequest) throws ServiceException {
        return ClientProtos.CleanupBulkLoadResponse.newBuilder().build();
    }

    public ClientProtos.CoprocessorServiceResponse execService(RpcController rpcController, ClientProtos.CoprocessorServiceRequest coprocessorServiceRequest) throws ServiceException {
        throw new UnsupportedOperationException("execService(rpcController,coprocessorServiceRequest) not supported");
    }

    public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController rpcController, ClientProtos.CoprocessorServiceRequest coprocessorServiceRequest) throws ServiceException {
        throw new UnsupportedOperationException("execRegionServerService(rpcController,coprocessorServiceRequest) not supported");
    }

    private void checkBatchSizeAndLogLargeSize(ClientProtos.MultiRequest request) {
        int sum = 0;
        String firstRegionName = null;
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            if (sum == 0) {
                firstRegionName = org.apache.hadoop.hbase.util.Bytes.toStringBinary((byte[])regionAction.getRegion().getValue().toByteArray());
            }
            sum += regionAction.getActionCount();
        }
        if (sum > this.rowSizeWarnThreshold) {
            LOG.warn("Large batch operation detected (greater than " + this.rowSizeWarnThreshold + ") (HBASE-18023). Requested Number of Rows: " + sum + " Client: " + (String)RpcServer.getRequestUserName().orElse(null) + "/" + RpcServer.getRemoteAddress().orElse(null) + " first region in multi=" + firstRegionName);
        }
    }

    public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
        CellScanner cellScanner;
        this.checkBatchSizeAndLogLargeSize(request);
        HBaseRpcController controller = (HBaseRpcController)rpcc;
        CellScanner cellScanner2 = cellScanner = controller != null ? controller.cellScanner() : null;
        if (controller != null) {
            controller.setCellScanner(null);
        }
        List<CellScannable> cellsToReturn = null;
        ClientProtos.MultiResponse.Builder responseBuilder = ClientProtos.MultiResponse.newBuilder();
        ClientProtos.RegionActionResult.Builder regionActionResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        RpcCallContext context = RpcServer.getCurrentCall().orElse(null);
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            if (regionAction.hasAtomic() && regionAction.getAtomic()) {
                throw new UnsupportedOperationException("Atomic action unsupported ");
            }
            regionActionResultBuilder.clear();
            HBaseProtos.RegionSpecifier regionSpecifier = regionAction.getRegion();
            try {
                byte[][] regionInfos = HRegionInfo.parseRegionName((byte[])regionSpecifier.getValue().toByteArray());
                TableName tb = TableName.valueOf((byte[])regionInfos[0]);
                cellsToReturn = this.doNonAtomicRegionMutation(tb, regionAction, cellScanner, regionActionResultBuilder, cellsToReturn, context);
            }
            catch (IOException e) {
                throw new ServiceException("Multi exception ", (Throwable)e);
            }
            responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
        }
        if (cellsToReturn != null && !cellsToReturn.isEmpty() && controller != null) {
            controller.setCellScanner(CellUtil.createCellScanner((List)cellsToReturn));
        }
        return responseBuilder.build();
    }

    private List<CellScannable> doNonAtomicRegionMutation(TableName tb, ClientProtos.RegionAction actions, CellScanner cellScanner, ClientProtos.RegionActionResult.Builder builder, List<CellScannable> cellsToReturn, RpcCallContext context) {
        Object r;
        ClientProtos.ResultOrException.Builder resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder();
        ArrayList<Object> rows = new ArrayList<Object>();
        for (ClientProtos.Action action : actions.getActionList()) {
            boolean hasResultOrException;
            block20: {
                hasResultOrException = false;
                resultOrExceptionBuilder.clear();
                try {
                    r = null;
                    if (action.hasGet()) {
                        ClientProtos.Get pbGet = action.getGet();
                        if (pbGet.hasClosestRowBefore() && pbGet.getClosestRowBefore()) {
                            throw new UnknownProtocolException("Is this a pre-hbase-1.0.0 or asynchbase client? Client is invoking getClosestRowBefore removed in hbase-2.0.0 replaced by reverse Scan.");
                        }
                        Get get2 = ProtobufUtil.toGet((ClientProtos.Get)pbGet);
                        rows.add(get2);
                        break block20;
                    }
                    if (action.hasServiceCall()) {
                        throw new UnsupportedOperationException("Service call in multi unsupported !");
                    }
                    if (action.hasMutation()) {
                        ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
                        switch (type) {
                            case APPEND: {
                                Append append2 = ProtobufUtil.toAppend((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner);
                                rows.add(append2);
                                break;
                            }
                            case INCREMENT: {
                                Increment increment2 = ProtobufUtil.toIncrement((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner);
                                rows.add(increment2);
                                break;
                            }
                            case PUT: {
                                Put put2 = ProtobufUtil.toPut((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner);
                                rows.add(put2);
                                break;
                            }
                            case DELETE: {
                                Delete delete = ProtobufUtil.toDelete((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner);
                                rows.add(delete);
                                break;
                            }
                            default: {
                                throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                            }
                        }
                        break block20;
                    }
                    throw new HBaseIOException("Unexpected Action type");
                }
                catch (IOException ie) {
                    hasResultOrException = true;
                    HBaseProtos.NameBytesPair pair = ResponseConverter.buildException((Throwable)ie);
                    resultOrExceptionBuilder.setException(pair);
                    context.incrementResponseExceptionSize((long)pair.getSerializedSize());
                }
            }
            if (!hasResultOrException) continue;
            resultOrExceptionBuilder.setIndex(action.getIndex());
            builder.addResultOrException(resultOrExceptionBuilder.build());
        }
        if (!CollectionUtils.isEmpty(rows)) {
            Object[] results = new Object[rows.size()];
            try {
                this.connection.getTable(tb).batch(rows, results);
                for (int i = 0; i < rows.size(); ++i) {
                    r = results[i];
                    if (r instanceof Throwable) {
                        Throwable throwable = (Throwable)r;
                        builder.addResultOrException(AliHBaseUEClientService.getResultOrException(new Exception("Action exception ", throwable), i));
                        continue;
                    }
                    ClientProtos.Result pbResult = ProtobufUtil.toResult((Result)((Result)r));
                    resultOrExceptionBuilder.clear();
                    resultOrExceptionBuilder.setResult(pbResult);
                    resultOrExceptionBuilder.setIndex(i);
                    builder.addResultOrException(resultOrExceptionBuilder.build());
                }
            }
            catch (Exception e) {
                for (int i = 0; i < results.length; ++i) {
                    Object r2 = results[i];
                    if (r2 instanceof Throwable) {
                        ((Throwable)r2).printStackTrace();
                        builder.addResultOrException(AliHBaseUEClientService.getResultOrException(new Exception("Action exception ", (Throwable)r2), i));
                        continue;
                    }
                    builder.addResultOrException(AliHBaseUEClientService.getResultOrException(e, i));
                }
            }
        }
        return cellsToReturn;
    }

    private static ClientProtos.ResultOrException getResultOrException(Exception e, int index) {
        return AliHBaseUEClientService.getResultOrException(ResponseConverter.buildActionResult((Throwable)e), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.ResultOrException.Builder builder, int index) {
        return builder.setIndex(index).build();
    }
}

