/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.IseAueEnum;
import cn.xfyun.config.IseCategoryEnum;
import cn.xfyun.config.IseLanguageEnum;
import cn.xfyun.config.IseResultLevelEnum;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class IseHttpClient
extends HttpClient {
    private IseAueEnum aue;
    private String speexSize;
    private IseResultLevelEnum resultLevel;
    private IseLanguageEnum language;
    private IseCategoryEnum category;
    private String extraAbility;

    public IseHttpClient(Builder builder) {
        super((HttpBuilder)builder);
        this.aue = builder.aue;
        this.speexSize = builder.speexSize;
        this.resultLevel = builder.resultLevel;
        this.language = builder.language;
        this.category = builder.category;
        this.extraAbility = builder.extraAbility;
    }

    public String send(String audioBase64, String text) throws IOException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("aue", this.aue.getValue());
        jsonObject.addProperty("language", this.language.getValue());
        jsonObject.addProperty("category", this.category.getValue());
        if (this.aue.equals((Object)IseAueEnum.SPEEX)) {
            jsonObject.addProperty("speex_size", this.speexSize);
        }
        if (Objects.nonNull(this.extraAbility)) {
            jsonObject.addProperty("extra_ability", this.extraAbility);
        }
        Map header = Signature.signHttpHeaderCheckSum((String)this.appId, (String)this.apiKey, (String)jsonObject.toString());
        return this.sendPost(this.hostUrl, FORM, header, "audio=" + audioBase64 + "&text=" + text);
    }

    public IseAueEnum getAue() {
        return this.aue;
    }

    public String getSpeexSize() {
        return this.speexSize;
    }

    public IseResultLevelEnum getResultLevel() {
        return this.resultLevel;
    }

    public IseLanguageEnum getLanguage() {
        return this.language;
    }

    public IseCategoryEnum getCategory() {
        return this.category;
    }

    public String getExtraAbility() {
        return this.extraAbility;
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://api.xfyun.cn/v1/service/v1/ise";
        private IseAueEnum aue;
        private String speexSize = "70";
        private IseResultLevelEnum resultLevel = IseResultLevelEnum.ENTIRETY;
        private IseLanguageEnum language;
        private IseCategoryEnum category;
        private String extraAbility;

        public Builder(String appId, String apiKey, IseAueEnum aue, IseLanguageEnum language, IseCategoryEnum category) {
            super(HOST_URL, appId, apiKey, null);
            this.aue = aue;
            this.language = language;
            this.category = category;
        }

        public Builder aue(IseAueEnum aue) {
            this.aue = aue;
            return this;
        }

        public Builder speexSize(String speexSize) {
            this.speexSize = speexSize;
            return this;
        }

        public Builder resultLevel() {
            this.resultLevel = IseResultLevelEnum.SIMPLE;
            return this;
        }

        public Builder language(IseLanguageEnum language) {
            this.language = language;
            return this;
        }

        public Builder category(IseCategoryEnum category) {
            this.category = category;
            return this;
        }

        public Builder extraAbility() {
            this.extraAbility = "multi_dimension";
            return this;
        }

        public IseHttpClient build() {
            return new IseHttpClient(this);
        }
    }
}

