/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.api.IatClient;
import cn.xfyun.base.websocket.WebSocketClient;
import cn.xfyun.model.request.igr.IgrRequest;
import cn.xfyun.model.sign.AbstractSignature;
import cn.xfyun.model.sign.Hmac256Signature;
import cn.xfyun.service.common.AbstractTimedTask;
import cn.xfyun.service.igr.IgrSendTask;
import cn.xfyun.util.OkHttpUtils;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.security.SignatureException;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgrClient
extends WebSocketClient {
    private static final Logger logger = LoggerFactory.getLogger(IatClient.class);
    private JsonObject common;
    private JsonObject business;
    private JsonObject data;
    private String appId;
    private String ent;
    private String aue;
    private int rate;
    private Integer frameSize = 1280;
    private ExecutorService executorService;

    public IgrClient(Builder builder) {
        this.okHttpClient = builder.client != null ? builder.client : OkHttpUtils.getDefaultClient().newBuilder().proxy(builder.proxy).connectTimeout((long)builder.connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)builder.readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeout, TimeUnit.MILLISECONDS).callTimeout((long)builder.callTimeout, TimeUnit.MILLISECONDS).pingInterval((long)builder.pingInterval, TimeUnit.MILLISECONDS).retryOnConnectionFailure(builder.retryOnConnectionFailure).build();
        this.appId = builder.appId;
        this.ent = builder.ent;
        this.aue = builder.aue;
        this.rate = builder.rate;
        this.common = builder.common;
        this.business = builder.business;
        this.apiKey = builder.apiKey;
        this.apiSecret = builder.apiSecret;
        this.originHostUrl = builder.hostUrl;
        this.request = builder.request;
        this.frameSize = builder.frameSize;
        this.signature = builder.signature;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.callTimeout = builder.callTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.pingInterval = builder.pingInterval;
        this.executorService = null == builder.executorService ? Executors.newSingleThreadExecutor() : builder.executorService;
    }

    public void start(WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.createWebSocketConnect(webSocketListener);
    }

    public void sendMessage(byte[] bytes, Integer status) {
        IgrRequest frame = new IgrRequest();
        if (0 == status) {
            JsonObject common = new JsonObject();
            common.addProperty("app_id", this.appId);
            JsonObject business = new JsonObject();
            business.addProperty("ent", this.ent);
            business.addProperty("aue", this.aue);
            business.addProperty("rate", (Number)this.rate);
            frame.setCommon(common);
            frame.setBusiness(business);
        }
        JsonObject data = new JsonObject();
        data.addProperty("status", (Number)status);
        if (bytes == null || bytes.length == 0) {
            data.addProperty("audio", "");
        } else {
            data.addProperty("audio", Base64.getEncoder().encodeToString(bytes));
        }
        frame.setData(data);
        String json = StringUtils.gson.toJson((Object)frame);
        logger.debug("\u6027\u522b\u5e74\u9f84\u8bc6\u522b\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)json);
        this.webSocket.send(json);
    }

    public void send(File file, WebSocketListener webSocketListener) throws FileNotFoundException, MalformedURLException, SignatureException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.send(fileInputStream, webSocketListener);
    }

    public void send(String data, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getBytes());
        this.send(inputStream, webSocketListener);
    }

    public void send(InputStream inputStream, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.createWebSocketConnect(webSocketListener);
        if (inputStream == null) {
            this.webSocket.close(1000, null);
            return;
        }
        IgrSendTask igrSendTask = new IgrSendTask();
        new AbstractTimedTask.Builder().inputStream(inputStream).webSocketClient(this).build(igrSendTask);
        this.executorService.submit(igrSendTask);
    }

    public void send(byte[] bytes, Closeable closeable, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.createWebSocketConnect(webSocketListener);
        if (bytes == null || bytes.length == 0) {
            this.webSocket.close(1000, null);
            return;
        }
        IgrSendTask igrSendTask = new IgrSendTask();
        new AbstractTimedTask.Builder().bytes(bytes).webSocketClient(this).closeable(closeable).build(igrSendTask);
        this.executorService.submit(igrSendTask);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getEnt() {
        return this.ent;
    }

    public String getAue() {
        return this.aue;
    }

    public int getRate() {
        return this.rate;
    }

    public String getHostUrl() {
        return this.originHostUrl;
    }

    public String getOriginHostUrl() {
        return this.originHostUrl;
    }

    public Request getRequest() {
        return this.request;
    }

    public OkHttpClient getClient() {
        return this.okHttpClient;
    }

    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public int getCallTimeout() {
        return this.callTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public AbstractSignature getSignature() {
        return this.signature;
    }

    public Integer getFrameSize() {
        return this.frameSize;
    }

    public static class Builder {
        private JsonObject common = new JsonObject();
        private JsonObject business = new JsonObject();
        private String appId;
        private String ent = "igr";
        private String aue;
        private int rate = 8000;
        private String hostUrl = "https://ws-api.xfyun.cn/v2/igr";
        private String apiKey;
        private String apiSecret;
        private Hmac256Signature signature;
        private Integer frameSize = 1280;
        private Request request;
        private OkHttpClient client;
        private ExecutorService executorService;
        private Proxy proxy;
        boolean retryOnConnectionFailure = true;
        int callTimeout = 0;
        int connectTimeout = 10000;
        int readTimeout = 10000;
        int writeTimeout = 10000;
        int pingInterval = 0;

        public IgrClient build() {
            return new IgrClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret) {
            this.appId = appId;
            this.apiKey = apiKey;
            this.apiSecret = apiSecret;
            this.signature = new Hmac256Signature(apiKey, apiSecret, this.hostUrl);
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.common.addProperty("app_id", appId);
            return this;
        }

        public Builder ent(String ent) {
            this.ent = ent;
            this.business.addProperty("ent", ent);
            return this;
        }

        public Builder aue(String aue) {
            this.aue = aue;
            this.business.addProperty("aue", aue);
            return this;
        }

        public Builder rate(int rate) {
            this.rate = rate;
            this.business.addProperty("aue", this.aue);
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return this;
        }

        public Builder common(JsonObject common) {
            this.common = common;
            return this;
        }

        public Builder business(JsonObject business) {
            this.business = business;
            return this;
        }

        public Builder frameSize(Integer frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        public Builder addRequest(Request request) {
            this.request = request;
            return this;
        }

        public Builder addClient(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder callTimeout(long timeout, TimeUnit unit) {
            this.callTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.readTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.writeTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            this.pingInterval = Util.checkDuration((String)"interval", (long)interval, (TimeUnit)unit);
            return this;
        }

        public Builder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }
    }
}

