/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.WebSocketClient;
import cn.xfyun.model.request.iat.IatBusiness;
import cn.xfyun.model.request.iat.IatRequest;
import cn.xfyun.model.request.iat.IatRequestData;
import cn.xfyun.model.sign.AbstractSignature;
import cn.xfyun.service.common.AbstractTimedTask;
import cn.xfyun.service.iat.IatSendTask;
import cn.xfyun.util.OkHttpUtils;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.security.SignatureException;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IatClient
extends WebSocketClient {
    private static final Logger logger = LoggerFactory.getLogger(IatClient.class);
    private static final String SMALL_LANGUAGE = "http://iat-niche-api.xfyun.cn/v2/iat";
    private static final String CH_EN_LANGUAGE = "http://iat-api.xfyun.cn/v2/iat";
    private ExecutorService executorService;
    private String language;
    private String domain;
    private String accent;
    private String format;
    private String encoding;
    private int vadEos;
    private String dwa;
    private String pd;
    private int ptt;
    private String rlang;
    private int vinfo;
    private int nunum;
    private Integer speexSize;
    private Integer nbest;
    private Integer wbest;
    private Integer frameSize;

    public IatClient(Builder builder) {
        this.okHttpClient = builder.okHttpClient != null ? builder.okHttpClient : OkHttpUtils.getDefaultClient().newBuilder().proxy(builder.proxy).connectTimeout((long)builder.connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)builder.readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeout, TimeUnit.MILLISECONDS).callTimeout((long)builder.callTimeout, TimeUnit.MILLISECONDS).pingInterval((long)builder.pingInterval, TimeUnit.MILLISECONDS).retryOnConnectionFailure(builder.retryOnConnectionFailure).build();
        this.originHostUrl = builder.hostUrl;
        this.appId = builder.appId;
        this.apiKey = builder.apiKey;
        this.apiSecret = builder.apiSecret;
        this.language = builder.language;
        this.domain = builder.domain;
        this.accent = builder.accent;
        this.format = builder.format;
        this.encoding = builder.encoding;
        this.vadEos = builder.vad_eos;
        this.dwa = builder.dwa;
        this.pd = builder.pd;
        this.ptt = builder.ptt;
        this.rlang = builder.rlang;
        this.vinfo = builder.vinfo;
        this.nunum = builder.nunum;
        this.speexSize = builder.speex_size;
        this.nbest = builder.nbest;
        this.wbest = builder.wbest;
        this.frameSize = builder.frameSize;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.callTimeout = builder.callTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.pingInterval = builder.pingInterval;
        this.executorService = null == builder.executorService ? Executors.newSingleThreadExecutor() : builder.executorService;
    }

    public void start(WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.createWebSocketConnect(webSocketListener);
    }

    public void sendMessage(byte[] bytes, Integer status) {
        IatRequest frame = new IatRequest();
        if (0 == status) {
            JsonObject common = new JsonObject();
            common.addProperty("app_id", this.appId);
            frame.setCommon(common);
            IatBusiness business = new IatBusiness(this);
            frame.setBusiness(business);
        }
        IatRequestData data = new IatRequestData(this);
        data.setStatus(status);
        if (bytes == null || bytes.length == 0) {
            data.setAudio("");
        } else {
            data.setAudio(Base64.getEncoder().encodeToString(bytes));
        }
        frame.setData(data);
        String json = StringUtils.gson.toJson((Object)frame);
        logger.debug("\u8bed\u97f3\u542c\u5199\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)json);
        this.webSocket.send(json);
    }

    public void send(File file, WebSocketListener webSocketListener) throws FileNotFoundException, MalformedURLException, SignatureException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.send(fileInputStream, webSocketListener);
    }

    public void send(InputStream inputStream, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        if (inputStream == null) {
            return;
        }
        this.createWebSocketConnect(webSocketListener);
        IatSendTask iatSendTask = new IatSendTask();
        new AbstractTimedTask.Builder().inputStream(inputStream).webSocketClient(this).build(iatSendTask);
        this.executorService.submit(iatSendTask);
    }

    public void send(byte[] bytes, Closeable closeable, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        this.createWebSocketConnect(webSocketListener);
        IatSendTask iatSendTask = new IatSendTask();
        new AbstractTimedTask.Builder().bytes(bytes).webSocketClient(this).closeable(closeable).build(iatSendTask);
        this.executorService.submit(iatSendTask);
    }

    public String getHostUrl() {
        return this.originHostUrl;
    }

    public String getOriginHostUrl() {
        return this.originHostUrl;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAccent() {
        return this.accent;
    }

    public String getFormat() {
        return this.format;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getVad_eos() {
        return this.vadEos;
    }

    public String getDwa() {
        return this.dwa;
    }

    public String getPd() {
        return this.pd;
    }

    public int getPtt() {
        return this.ptt;
    }

    public String getRlang() {
        return this.rlang;
    }

    public int getVinfo() {
        return this.vinfo;
    }

    public int getNunum() {
        return this.nunum;
    }

    public Integer getSpeex_size() {
        return this.speexSize;
    }

    public Integer getNbest() {
        return this.nbest;
    }

    public Integer getWbest() {
        return this.wbest;
    }

    public Integer getFrameSize() {
        return this.frameSize;
    }

    public AbstractSignature getSignature() {
        return this.signature;
    }

    public Request getRequest() {
        return this.request;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public int getCallTimeout() {
        return this.callTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public static class Builder {
        boolean retryOnConnectionFailure = true;
        int callTimeout = 0;
        int connectTimeout = 10000;
        int readTimeout = 10000;
        int writeTimeout = 10000;
        int pingInterval = 0;
        private String hostUrl = "http://iat-api.xfyun.cn/v2/iat";
        private String appId;
        private String apiKey;
        private String apiSecret;
        private String language = "zh_cn";
        private String domain = "iat";
        private String accent = "mandarin";
        private String format = "audio/L16;rate=16000";
        private String encoding = "raw";
        private int vad_eos = 2000;
        private String dwa;
        private String pd;
        private int ptt = 1;
        private String rlang = "zh-cn";
        private int vinfo = 0;
        private int nunum = 1;
        private Integer speex_size = 2;
        private Integer nbest;
        private Integer wbest;
        private Integer frameSize = 1280;
        private ExecutorService executorService;
        private OkHttpClient okHttpClient;
        private Proxy proxy;

        public IatClient build() {
            return new IatClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret) {
            this.appId = appId;
            this.apiKey = apiKey;
            this.apiSecret = apiSecret;
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder smallLanguage(Boolean isSmallLanguage) {
            this.hostUrl = isSmallLanguage != false ? IatClient.SMALL_LANGUAGE : IatClient.CH_EN_LANGUAGE;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder accent(String accent) {
            this.accent = accent;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder vad_eos(int vad_eos) {
            this.vad_eos = vad_eos;
            return this;
        }

        public Builder dwa(String dwa) {
            this.dwa = dwa;
            return this;
        }

        public Builder pd(String pd) {
            this.pd = pd;
            return this;
        }

        public Builder ptt(int ptt) {
            this.ptt = ptt;
            return this;
        }

        public Builder rlang(String rlang) {
            this.rlang = rlang;
            return this;
        }

        public Builder vinfo(int vinfo) {
            this.vinfo = vinfo;
            return this;
        }

        public Builder nunum(int nunum) {
            this.nunum = nunum;
            return this;
        }

        public Builder speex_size(Integer speex_size) {
            this.speex_size = speex_size;
            return this;
        }

        public Builder nbest(Integer nbest) {
            this.nbest = nbest;
            return this;
        }

        public Builder wbest(Integer wbest) {
            this.wbest = wbest;
            return this;
        }

        public Builder frameSize(Integer frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        public Builder callTimeout(long timeout, TimeUnit unit) {
            this.callTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.readTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.writeTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            this.pingInterval = Util.checkDuration((String)"interval", (long)interval, (TimeUnit)unit);
            return this;
        }

        public Builder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }
    }
}

