/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.aippt.request;

import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.aippt.request.Outline;
import cn.xfyun.util.StringUtils;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class PPTCreate {
    private String query;
    private File file;
    private String fileUrl;
    private String fileName;
    private String templateId;
    private String businessId;
    private String author;
    private Boolean isCardNote;
    private Boolean search;
    private String language;
    private Boolean isFigure;
    private String aiImage;
    private Outline outline;
    private String outlineSid;

    public PPTCreate(Builder builder) {
        this.query = builder.query;
        this.file = builder.file;
        this.fileUrl = builder.fileUrl;
        this.fileName = builder.fileName;
        this.templateId = builder.templateId;
        this.businessId = builder.businessId;
        this.author = builder.author;
        this.isCardNote = builder.isCardNote;
        this.search = builder.search;
        this.language = builder.language;
        this.isFigure = builder.isFigure;
        this.aiImage = builder.aiImage;
        this.outline = builder.outline;
        this.outlineSid = builder.outlineSid;
    }

    public PPTCreate() {
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Boolean getCardNote() {
        return this.isCardNote;
    }

    public void setCardNote(Boolean cardNote) {
        this.isCardNote = cardNote;
    }

    public Boolean getSearch() {
        return this.search;
    }

    public void setSearch(Boolean search) {
        this.search = search;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Boolean getFigure() {
        return this.isFigure;
    }

    public void setFigure(Boolean figure) {
        this.isFigure = figure;
    }

    public String getAiImage() {
        return this.aiImage;
    }

    public void setAiImage(String aiImage) {
        this.aiImage = aiImage;
    }

    public Outline getOutline() {
        return this.outline;
    }

    public void setOutline(Outline outline) {
        this.outline = outline;
    }

    public String getOutlineSid() {
        return this.outlineSid;
    }

    public void setOutlineSid(String outlineSid) {
        this.outlineSid = outlineSid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toJSONString() {
        return StringUtils.gson.toJson((Object)this);
    }

    public void createCheck() {
        if (!StringUtils.isNullOrEmpty((String)this.query) && this.query.length() > 8000) {
            throw new BusinessException("query\u53c2\u6570\u6700\u59278000\u5b57\u7b26");
        }
        if (this.file == null && StringUtils.isNullOrEmpty((String)this.fileUrl) && StringUtils.isNullOrEmpty((String)this.query)) {
            throw new BusinessException("query\u3001file\u3001fileUrl\u53c2\u6570\u5fc5\u586b\u5176\u4e00");
        }
        if ((null != this.file || !StringUtils.isNullOrEmpty((String)this.fileUrl)) && StringUtils.isNullOrEmpty((String)this.fileName)) {
            throw new BusinessException("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public RequestBody toFormDataBody() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (!StringUtils.isNullOrEmpty((String)this.query)) {
            builder.addFormDataPart("query", this.query);
        }
        if (null != this.file) {
            builder.addFormDataPart("file", this.file.getName(), RequestBody.create((MediaType)MultipartBody.FORM, (File)this.file));
        }
        if (!StringUtils.isNullOrEmpty((String)this.fileUrl)) {
            builder.addFormDataPart("fileUrl", this.fileUrl);
        }
        if (!StringUtils.isNullOrEmpty((String)this.fileName)) {
            builder.addFormDataPart("fileName", this.fileName);
        }
        if (!StringUtils.isNullOrEmpty((String)this.templateId)) {
            builder.addFormDataPart("templateId", this.templateId);
        }
        if (!StringUtils.isNullOrEmpty((String)this.businessId)) {
            builder.addFormDataPart("businessId", this.businessId);
        }
        if (!StringUtils.isNullOrEmpty((String)this.author)) {
            builder.addFormDataPart("author", this.author);
        }
        if (null != this.isCardNote) {
            builder.addFormDataPart("isCardNote", String.valueOf(this.isCardNote));
        }
        if (null != this.search) {
            builder.addFormDataPart("search", String.valueOf(this.search));
        }
        if (!StringUtils.isNullOrEmpty((String)this.language)) {
            builder.addFormDataPart("language", this.language);
        }
        if (null != this.isFigure) {
            builder.addFormDataPart("isFigure", String.valueOf(this.isFigure));
        }
        if (!StringUtils.isNullOrEmpty((String)this.aiImage)) {
            builder.addFormDataPart("aiImage", this.aiImage);
        }
        return builder.build();
    }

    public void createOutLineCheck() {
        if (StringUtils.isNullOrEmpty((String)this.query) || this.query.length() > 8000) {
            throw new BusinessException("query\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
    }

    public void createOutlineByDocCheck() {
        if (StringUtils.isNullOrEmpty((String)this.fileName)) {
            throw new BusinessException("fileName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNullOrEmpty((String)this.fileUrl) && null == this.file) {
            throw new BusinessException("(file\u3001fileUrl\u5fc5\u586b\u5176\u4e00");
        }
    }

    public void createPptByOutlineCheck() {
        if (StringUtils.isNullOrEmpty((String)this.query) || this.query.length() > 8000) {
            throw new BusinessException("query\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        if (null == this.outline) {
            throw new BusinessException("\u5927\u7eb2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static final class Builder {
        private String query;
        private File file;
        private String fileUrl;
        private String fileName;
        private String templateId;
        private String businessId;
        private String author = "\u8baf\u98de\u667a\u6587";
        private Boolean isCardNote = false;
        private Boolean search = false;
        private String language = "cn";
        private Boolean isFigure = false;
        private String aiImage;
        private Outline outline;
        private String outlineSid;

        private Builder() {
        }

        public PPTCreate build() {
            return new PPTCreate(this);
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder file(File file, String fileName) {
            this.file = file;
            this.fileName = fileName;
            return this;
        }

        public Builder fileUrl(String fileUrl, String fileName) {
            this.fileUrl = fileUrl;
            this.fileName = fileName;
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder businessId(String businessId) {
            this.businessId = businessId;
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder isCardNote(Boolean isCardNote) {
            this.isCardNote = isCardNote;
            return this;
        }

        public Builder search(Boolean search) {
            this.search = search;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder isFigure(Boolean isFigure) {
            this.isFigure = isFigure;
            return this;
        }

        public Builder aiImage(String aiImage) {
            this.aiImage = aiImage;
            return this;
        }

        public Builder outline(Outline outline) {
            this.outline = outline;
            return this;
        }

        public Builder outlineSid(String outlineSid) {
            this.outlineSid = outlineSid;
            return this;
        }
    }
}

