/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.resume.ResumeRequest;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.util.StringUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeGenClient
extends PlatformHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(ResumeGenClient.class);

    public ResumeGenClient(Builder builder) {
        super((PlatformBuilder)builder);
    }

    public String send(String text) throws IOException {
        this.paramCheck(text);
        String realUrl = Signature.signHostDateAuthorization((String)(this.hostUrl + this.serviceId), (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        String body = this.buildParam(text, realUrl);
        return this.sendPost(realUrl, JSON, null, body);
    }

    private void paramCheck(String text) {
        if (StringUtils.isNullOrEmpty((String)text)) {
            throw new BusinessException("text\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildParam(String text, String realUrl) {
        ResumeRequest request = new ResumeRequest();
        ResumeRequest.HeaderBean header = new ResumeRequest.HeaderBean();
        header.setAppId(this.appId);
        header.setStatus(this.status);
        request.setHeader(header);
        ResumeRequest.ParameterBean parameter = new ResumeRequest.ParameterBean(this);
        request.setParameter(parameter);
        ResumeRequest.PayloadBean payload = new ResumeRequest.PayloadBean(this);
        payload.getReqData().setText(Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8)));
        payload.getReqData().setStatus(this.status);
        request.setPayload(payload);
        String body = StringUtils.gson.toJson((Object)request);
        logger.debug("\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u4f53\uff1a{}", (Object)realUrl, (Object)body);
        return body;
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://cn-huadong-1.xf-yun.com/v1/private/";
        private static final String SERVICE_ID = "s73f4add9";

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, SERVICE_ID, appId, apiKey, apiSecret);
            this.readTimeout(120);
        }

        public ResumeGenClient build() {
            return new ResumeGenClient(this);
        }
    }
}

