/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.maas.MaasParam;
import cn.xfyun.model.maas.request.MaasHttpRequest;
import cn.xfyun.model.maas.request.MaasReqeust;
import cn.xfyun.util.StringUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.SignatureException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaasClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(MaasClient.class);
    private final List<String> patchId;
    private final String domain;
    private final Float temperature;
    private final Integer topK;
    private final Integer maxTokens;
    private final String requestUrl;
    private final String auditing;
    private final boolean searchDisable;
    private final boolean showRefLabel;
    private final Map<String, Object> streamOptions;

    public MaasClient(Builder builder) {
        super((WebsocketBuilder)builder);
        if (null != builder.wsUrl) {
            this.originHostUrl = builder.wsUrl.replace("ws://", "http://").replace("wss://", "https://");
        }
        this.requestUrl = builder.requestUrl;
        this.patchId = builder.patchId;
        this.domain = builder.domain;
        this.temperature = builder.temperature;
        this.topK = builder.topK;
        this.maxTokens = builder.maxTokens;
        this.auditing = "default";
        this.searchDisable = builder.searchDisable;
        this.showRefLabel = builder.showRefLabel;
        this.streamOptions = builder.streamOptions;
    }

    public String getAuditing() {
        return this.auditing;
    }

    public List<String> getPatchId() {
        return this.patchId;
    }

    public String getDomain() {
        return this.domain;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public boolean isSearchDisable() {
        return this.searchDisable;
    }

    public boolean isShowRefLabel() {
        return this.showRefLabel;
    }

    public Map<String, Object> getStreamOptions() {
        return this.streamOptions;
    }

    public void send(MaasParam param, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.textCheck(param);
        WebSocket socket = this.newWebSocket(webSocketListener);
        try {
            String jsonStr = this.buildParam(param);
            logger.debug("\u7cbe\u8c03\u6587\u672c\u5927\u6a21\u578bws\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)jsonStr);
            socket.send(jsonStr);
        }
        catch (Exception e) {
            logger.error("ws\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    public String send(MaasParam param) throws IOException {
        this.textCheck(param);
        String body = this.buildPostParam(param, false);
        Request requestUrl = this.getRequest(body);
        try (Response response = this.okHttpClient.newCall(requestUrl).execute();){
            String string = Objects.requireNonNull(response.body(), "\u7cbe\u8c03\u6587\u672c\u5927\u6a21\u578bpost\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a").string();
            return string;
        }
    }

    public void send(MaasParam param, Callback callback) {
        this.textCheck(param);
        String body = this.buildPostParam(param, true);
        Request sseRequest = this.getSseRequest(body);
        this.okHttpClient.newCall(sseRequest).enqueue(callback);
    }

    private Request getSseRequest(String body) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)this.requestUrl), "\u8bf7\u6c42\u5730\u5740\u9519\u8bef\uff1a" + this.requestUrl).newBuilder();
        Request.Builder builder = new Request.Builder().url(urlBuilder.build().toString()).post(RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)body));
        builder.addHeader("Authorization", "Bearer " + this.apiKey);
        builder.addHeader("Accept", "text/event-stream");
        return builder.build();
    }

    private Request getRequest(String body) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)this.requestUrl), "\u8bf7\u6c42\u5730\u5740\u9519\u8bef\uff1a" + this.requestUrl).newBuilder();
        Request.Builder builder = new Request.Builder().url(urlBuilder.build().toString()).post(RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)body));
        builder.addHeader("Authorization", "Bearer " + this.apiKey);
        return builder.build();
    }

    private String buildParam(MaasParam param) {
        MaasReqeust request = new MaasReqeust();
        MaasReqeust.Header header = new MaasReqeust.Header();
        header.setAppId(this.appId);
        header.setUid(param.getUserId());
        header.setPatchId(this.patchId);
        request.setHeader(header);
        MaasReqeust.Parameter parameter = new MaasReqeust.Parameter(this);
        parameter.getChat().setChatId(param.getChatId());
        parameter.getChat().setSearchDisable(this.searchDisable);
        parameter.getChat().setShowRefLabel(this.showRefLabel);
        request.setParameter(parameter);
        MaasReqeust.Payload payload = new MaasReqeust.Payload();
        payload.getMessage().setText(param.getMessages());
        request.setPayload(payload);
        return StringUtils.gson.toJson((Object)request);
    }

    private String buildPostParam(MaasParam param, boolean stream) {
        Map body;
        MaasHttpRequest request = new MaasHttpRequest();
        request.setModel(this.domain);
        request.setMessages(param.getMessages());
        request.setStream(stream);
        request.setMaxTokens(this.maxTokens);
        request.setTemperature(this.temperature);
        Map<String, Object> headers = param.getExtraHeaders();
        if (headers != null && !headers.isEmpty()) {
            request.setExtraHeaders(StringUtils.gson.toJsonTree(headers));
        }
        if (!(body = Optional.ofNullable(param.getExtraBody()).orElseGet(HashMap::new)).containsKey("show_ref_label")) {
            body.put("show_ref_label", this.showRefLabel);
        }
        if (!body.containsKey("search_disable")) {
            body.put("search_disable", this.searchDisable);
        }
        request.setExtraBody(StringUtils.gson.toJsonTree((Object)body));
        if (this.streamOptions != null && !this.streamOptions.isEmpty()) {
            request.setStreamOptions(StringUtils.gson.toJsonTree(this.streamOptions));
        }
        String json = StringUtils.gson.toJson((Object)request);
        logger.debug("\u7cbe\u8c03\u6587\u672c\u5927\u6a21\u578b http \u8bf7\u6c42 URL\uff1a{}\uff0c\u53c2\u6570\uff1a{}", (Object)this.requestUrl, (Object)body);
        return json;
    }

    private void textCheck(MaasParam param) {
        if (param == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getMessages() == null || param.getMessages().isEmpty()) {
            throw new BusinessException("\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static final class Builder
    extends WebsocketBuilder<Builder> {
        private String wsUrl = "wss://maas-api.cn-huabei-1.xf-yun.com/v1.1/chat";
        private String requestUrl = "https://maas-api.cn-huabei-1.xf-yun.com/v1";
        private List<String> patchId;
        private String domain;
        private Float temperature = Float.valueOf(0.5f);
        private Integer topK = 4;
        private Integer maxTokens = 2048;
        private final String auditing = "default";
        private boolean searchDisable = true;
        private boolean showRefLabel = false;
        private Map<String, Object> streamOptions;

        public MaasClient build() {
            return new MaasClient(this);
        }

        public Builder signatureWs(String resourceId, String modelId, String appId, String apiKey, String apiSecret) {
            super.signature(appId, apiKey, apiSecret);
            super.readTimeout(60000L, TimeUnit.MILLISECONDS);
            this.patchId = Collections.singletonList(resourceId);
            this.domain = modelId;
            return this;
        }

        public Builder signatureHttp(String resourceId, String modelId, String apiKey) {
            super.signature(null, apiKey, null);
            super.readTimeout(60000L, TimeUnit.MILLISECONDS);
            this.patchId = Collections.singletonList(resourceId);
            this.domain = modelId;
            return this;
        }

        public Builder patchId(List<String> patchId) {
            this.patchId = patchId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder wsUrl(String wsUrl) {
            this.wsUrl = wsUrl;
            return this;
        }

        public Builder requestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
            return this;
        }

        public Builder searchDisable(boolean searchDisable) {
            this.searchDisable = searchDisable;
            return this;
        }

        public Builder showRefLabel(boolean showRefLabel) {
            this.showRefLabel = showRefLabel;
            return this;
        }

        public Builder streamOptions(Map<String, Object> streamOptions) {
            this.streamOptions = streamOptions;
            return this;
        }
    }
}

