/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.Role;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.image.ImageGenParam;
import cn.xfyun.model.image.request.ImageGenRequest;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.model.sparkmodel.RoleContent;
import cn.xfyun.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageGenClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(ImageGenClient.class);
    private final int width;
    private final int height;
    private final String domain;

    public ImageGenClient(Builder builder) {
        super((HttpBuilder)builder);
        this.domain = builder.domain;
        this.width = builder.width;
        this.height = builder.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getDomain() {
        return this.domain;
    }

    public String send(ImageGenParam param) throws IOException {
        this.paramCheck(param);
        String realUrl = Signature.signHostDateAuthorization((String)this.hostUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        String body = this.buildParam(param, realUrl);
        return this.sendPost(realUrl, JSON, null, body);
    }

    public String send(String text) throws IOException {
        ImageGenParam param = this.buildParam(text);
        return this.send(param);
    }

    private ImageGenParam buildParam(String text) {
        ArrayList<RoleContent> messages = new ArrayList<RoleContent>();
        RoleContent roleContent = new RoleContent();
        roleContent.setRole(Role.USER.getValue());
        roleContent.setContent(text);
        messages.add(roleContent);
        return ImageGenParam.builder().messages(messages).build();
    }

    private void paramCheck(ImageGenParam param) {
        if (null == param) {
            throw new BusinessException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == param.getMessages() || param.getMessages().isEmpty()) {
            throw new BusinessException("\u56fe\u7247\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildParam(ImageGenParam param, String realUrl) {
        ImageGenRequest request = new ImageGenRequest();
        ImageGenRequest.Header header = new ImageGenRequest.Header();
        header.setAppId(this.appId);
        request.setHeader(header);
        int width = param.getWidth() == null ? this.width : param.getWidth();
        int height = param.getHeight() == null ? this.height : param.getHeight();
        ImageGenRequest.Parameter parameter = new ImageGenRequest.Parameter();
        ImageGenRequest.Parameter.Chat chat = new ImageGenRequest.Parameter.Chat();
        chat.setDomain(this.domain);
        chat.setWidth(width);
        chat.setHeight(height);
        parameter.setChat(chat);
        request.setParameter(parameter);
        ImageGenRequest.Payload payload = new ImageGenRequest.Payload();
        ImageGenRequest.Payload.Message message = new ImageGenRequest.Payload.Message();
        message.setText(param.getMessages());
        payload.setMessage(message);
        request.setPayload(payload);
        String json = StringUtils.gson.toJson((Object)request);
        logger.debug("\u56fe\u7247\u751f\u6210\u8bf7\u6c42URL: {}, \u8bf7\u6c42\u4f53: {}", (Object)realUrl, (Object)json);
        return json;
    }

    public static class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://spark-api.cn-huabei-1.xf-yun.com/v2.1/tti";
        private String domain = "general";
        private int width = 512;
        private int height = 512;

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, appId, apiKey, apiSecret);
            this.readTimeout(60);
        }

        public ImageGenClient build() {
            return new ImageGenClient(this);
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }
    }
}

