/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.AiUiKnowledge;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.aiui.knowledge.CreateParam;
import cn.xfyun.model.aiui.knowledge.DeleteParam;
import cn.xfyun.model.aiui.knowledge.LinkParam;
import cn.xfyun.model.aiui.knowledge.SearchParam;
import cn.xfyun.model.aiui.knowledge.UploadParam;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiUiKnowledgeClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(AiUiKnowledgeClient.class);
    private final String apiPassword;

    public AiUiKnowledgeClient(Builder builder) {
        super((HttpBuilder)builder);
        this.apiPassword = builder.apiPassword;
    }

    public String getApiPassword() {
        return this.apiPassword;
    }

    public String create(CreateParam param) throws IOException {
        this.nullCheck(param);
        param.createCheck();
        RequestBody body = RequestBody.create((MediaType)JSON, (String)param.toJSONString());
        return this.send(AiUiKnowledge.CREATE, body, null);
    }

    public String upload(UploadParam param) throws IOException {
        this.nullCheck(param);
        param.uploadCheck();
        return this.send(AiUiKnowledge.UPLOAD, param.toFormDataBody(), null);
    }

    public String delete(DeleteParam param) throws IOException {
        this.nullCheck(param);
        param.deleteCheck();
        return this.send(AiUiKnowledge.DELETE, null, param);
    }

    public String list(SearchParam param) throws IOException {
        this.nullCheck(param);
        param.searchCheck();
        return this.send(AiUiKnowledge.LIST, null, param);
    }

    public String link(LinkParam param) throws IOException {
        this.nullCheck(param);
        param.linkCheck();
        RequestBody body = RequestBody.create((MediaType)JSON, (String)param.toJSONString());
        return this.send(AiUiKnowledge.LINK, body, null);
    }

    private void nullCheck(Object param) {
        if (param == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String send(AiUiKnowledge aiUiKnowledge, RequestBody body, Object param) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>(6);
        header.put("Authorization", "Bearer " + this.apiPassword);
        String url = this.hostUrl + aiUiKnowledge.getUrl();
        HttpUrl.Builder builder = Objects.requireNonNull(HttpUrl.parse((String)url), "\u975e\u6cd5\u7684\u8bf7\u6c42\u8def\u5f84: " + url).newBuilder();
        if (param != null) {
            JsonElement jsonTree = StringUtils.gson.toJsonTree(param);
            for (Map.Entry entry : jsonTree.getAsJsonObject().entrySet()) {
                if (((JsonElement)entry.getValue()).isJsonNull()) continue;
                builder.addQueryParameter((String)entry.getKey(), ((JsonElement)entry.getValue()).toString());
            }
        }
        url = builder.toString();
        logger.debug("{}\u8bf7\u6c42URL\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{aiUiKnowledge.getDesc(), url, null == body ? "" : body.toString()});
        return this.sendRequest(url, aiUiKnowledge.getMethod(), header, body);
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://sparkcons-rag.cn-huabei-1.xf-yun.com/aiuiKnowledge/rag/api";
        private final String apiPassword;

        public Builder(String apiPassword) {
            super(HOST_URL, null, null, null);
            this.apiPassword = apiPassword;
            this.readTimeout(120);
        }

        public AiUiKnowledgeClient build() {
            return new AiUiKnowledgeClient(this);
        }
    }
}

