/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.WorkFlowEnum;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.agent.AgentChatParam;
import cn.xfyun.model.agent.AgentResumeParam;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(AgentClient.class);

    public AgentClient(Builder builder) {
        super((HttpBuilder)builder);
    }

    public void completion(AgentChatParam param, Callback callback) {
        this.paramCheck(param);
        param.setStream(Boolean.TRUE);
        Request sseRequest = this.getSseRequest(this.hostUrl + WorkFlowEnum.COMPLETIONS.getUrl(), param.toJSONString());
        this.okHttpClient.newCall(sseRequest).enqueue(callback);
    }

    public String completion(AgentChatParam param) throws IOException {
        this.paramCheck(param);
        param.setStream(Boolean.FALSE);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)param.toJSONString());
        return this.send(WorkFlowEnum.COMPLETIONS, body, new Object[0]);
    }

    public void resume(AgentResumeParam param, Callback callback) {
        this.paramCheck(param);
        Request sseRequest = this.getSseRequest(this.hostUrl + WorkFlowEnum.RESUME.getUrl(), param.toJSONString());
        this.okHttpClient.newCall(sseRequest).enqueue(callback);
    }

    public String uploadFile(File file) throws IOException {
        this.paramCheck(file);
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MultipartBody.FORM, (File)file)).build();
        return this.send(WorkFlowEnum.UPLOAD_FILE, (RequestBody)body, new Object[0]);
    }

    private Request getSseRequest(String url, String body) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)url), "\u8bf7\u6c42\u5730\u5740\u9519\u8bef\uff1a" + url).newBuilder();
        Request.Builder builder = new Request.Builder().url(urlBuilder.build().toString()).post(RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)body));
        builder.addHeader("Authorization", "Bearer " + this.apiKey + ":" + this.apiSecret);
        builder.addHeader("Accept", "text/event-stream");
        return builder.build();
    }

    private String send(WorkFlowEnum workFlowEnum, RequestBody body, Object ... param) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>(6);
        header.put("Authorization", "Bearer " + this.apiKey + ":" + this.apiSecret);
        String url = this.hostUrl + workFlowEnum.getUrl();
        if (param != null) {
            url = String.format(url, param);
        }
        logger.debug("{}\u8bf7\u6c42URL\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{workFlowEnum.getDesc(), url, null == body ? "" : body.toString()});
        return this.sendRequest(url, workFlowEnum.getMethod(), header, body);
    }

    private void paramCheck(Object param) {
        if (param == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param instanceof AgentChatParam) {
            ((AgentChatParam)param).selfCheck();
        } else if (param instanceof AgentResumeParam) {
            ((AgentResumeParam)param).selfCheck();
        } else if (param instanceof File && !((File)param).exists()) {
            throw new BusinessException("\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://xingchen-api.xf-yun.com/workflow/v1";

        public Builder(String apikey, String apiSecret) {
            super(HOST_URL, null, apikey, apiSecret);
            this.readTimeout(600);
        }

        public AgentClient build() {
            return new AgentClient(this);
        }
    }
}

