/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.document;

import cn.xfyun.model.common.response.ResponseHeader;
import cn.xfyun.model.document.response.PDRecResponse;
import cn.xfyun.util.StringUtils;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPDRecWebSocketListener
extends WebSocketListener {
    private static final Gson JSON = new Gson();
    private static final Logger logger = LoggerFactory.getLogger(AbstractPDRecWebSocketListener.class);
    private static final int END = 2;
    private byte[] bytes = new byte[0];
    private final File file;
    private FileOutputStream outputStream;

    public AbstractPDRecWebSocketListener() {
        this.file = null;
    }

    public AbstractPDRecWebSocketListener(File file) throws IOException {
        this.file = file;
        if (file != null) {
            this.ensureDirectoryExists(file.getParentFile());
            this.outputStream = new FileOutputStream(file, true);
        }
    }

    private void ensureDirectoryExists(File directory) throws IOException {
        if (!directory.exists()) {
            Files.createDirectories(directory.toPath(), new FileAttribute[0]);
        }
    }

    public abstract void onSuccess(byte[] var1);

    public abstract void onClose(WebSocket var1, int var2, String var3);

    public abstract void onFail(WebSocket var1, Throwable var2, Response var3);

    public abstract void onBusinessFail(WebSocket var1, PDRecResponse var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
        try {
            logger.debug("Handshake success, code={}, headers={}", (Object)response.code(), (Object)response.headers());
        }
        finally {
            try {
                response.close();
            }
            catch (Exception closeError) {
                logger.warn("response close failed", (Throwable)closeError);
            }
        }
    }

    public void onMessage(WebSocket webSocket, String text) {
        logger.debug("Received message: {}", (Object)text);
        try {
            PDRecResponse response = (PDRecResponse)JSON.fromJson(text, PDRecResponse.class);
            if (response == null || response.getHeader() == null) {
                return;
            }
            ResponseHeader header = response.getHeader();
            if (header.getCode() != 0) {
                logger.error("Error: {} (CODE={}, SID={})", new Object[]{header.getMessage(), header.getCode(), header.getSid()});
                this.onBusinessFail(webSocket, response);
                return;
            }
            if (header.getStatus() == 1) {
                PDRecResponse.Payload payload = response.getPayload();
                if (payload == null || payload.getResult() == null) {
                    return;
                }
                String textData = payload.getResult().getText();
                if (textData != null) {
                    byte[] audioBytes = Base64.getDecoder().decode(textData);
                    this.bytes = StringUtils.unitByteArray((byte[])this.bytes, (byte[])audioBytes);
                }
            }
            if (header.getStatus() == 2) {
                this.handleFinalAudio(webSocket);
            }
        }
        catch (Exception e) {
            logger.error("Failed to process message", (Throwable)e);
            this.onFail(webSocket, e, null);
        }
    }

    private void handleFinalAudio(WebSocket webSocket) {
        if (this.file != null && this.outputStream != null) {
            try (FileOutputStream fos = this.outputStream;){
                fos.write(this.bytes);
                fos.flush();
                logger.debug("File saved at: {}", (Object)this.file.getPath());
            }
            catch (IOException e) {
                logger.error("Error writing document file", (Throwable)e);
                this.onBusinessFail(webSocket, new PDRecResponse(-1, "File Write Error"));
            }
        }
        this.onSuccess(this.bytes);
        this.closeWebSocket(webSocket);
    }

    private void closeWebSocket(WebSocket webSocket) {
        try {
            webSocket.close(1000, "");
        }
        catch (Exception e) {
            logger.warn("Error closing WebSocket", (Throwable)e);
        }
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.onClose(webSocket, code, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        super.onFailure(webSocket, t, response);
        try {
            this.onFail(webSocket, t, response);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception closeError) {
                    logger.warn("response close failed", (Throwable)closeError);
                }
            }
        }
    }
}

