/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.config.DocumentType;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.model.ticket.TicketOCRParam;
import cn.xfyun.model.ticket.request.TicketOCRRequest;
import cn.xfyun.util.StringUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketOCRClient
extends PlatformHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(TicketOCRClient.class);

    public TicketOCRClient(Builder builder) {
        super((PlatformBuilder)builder);
    }

    public String send(TicketOCRParam param) throws IOException {
        this.paramCheck(param);
        String signUrl = Signature.signHostDateAuthorization((String)this.hostUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        return this.sendPost(signUrl, JSON, this.bodyParam(param));
    }

    private void paramCheck(TicketOCRParam param) {
        if (null == param) {
            throw new BusinessException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        param.selfCheck();
    }

    private String bodyParam(TicketOCRParam param) {
        DocumentType documentType = param.getDocumentType();
        TicketOCRRequest request = new TicketOCRRequest();
        TicketOCRRequest.Header header = new TicketOCRRequest.Header();
        header.setAppId(this.appId);
        header.setUid(param.getUid());
        header.setStatus(this.status);
        request.setHeader(header);
        TicketOCRRequest.Parameter parameter = new TicketOCRRequest.Parameter(this);
        parameter.getOcr().setType(documentType.getType());
        parameter.getOcr().setLevel(param.getLevel());
        request.setParameter(parameter);
        TicketOCRRequest.Payload payload = new TicketOCRRequest.Payload();
        TicketOCRRequest.Payload.Image image = new TicketOCRRequest.Payload.Image();
        image.setImage(param.getImageBase64());
        image.setStatus(this.status);
        image.setEncoding(param.getImageFormat());
        payload.setImage(image);
        request.setPayload(payload);
        String json = StringUtils.gson.toJson((Object)request);
        logger.debug("{} \u8bc6\u522b\u8bf7\u6c42\u5165\u53c2: {}", (Object)documentType.getDesc(), (Object)json);
        logger.info("{} \u8bc6\u522b\u5f00\u59cb...", (Object)documentType.getDesc());
        return json;
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://cn-huadong-1.xf-yun.com/v1/inv";

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, null, appId, apiKey, apiSecret);
            this.readTimeout(30);
        }

        public TicketOCRClient build() {
            return new TicketOCRClient(this);
        }
    }
}

