/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.model.ticket.request.SinoOCRRequest;
import cn.xfyun.util.StringUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinoOCRClient
extends PlatformHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(SinoOCRClient.class);

    public SinoOCRClient(Builder builder) {
        super((PlatformBuilder)builder);
    }

    public String send(String imgBase64, String imgFormat) throws IOException {
        if (StringUtils.isNullOrEmpty((String)imgBase64)) {
            throw new BusinessException("\u56fe\u7247\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String signUrl = Signature.signHostDateAuthorization((String)(this.hostUrl + this.serviceId), (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        return this.sendPost(signUrl, JSON, this.bodyParam(imgBase64, imgFormat));
    }

    private String bodyParam(String imgBase64, String imgFormat) {
        SinoOCRRequest request = new SinoOCRRequest();
        SinoOCRRequest.Header header = new SinoOCRRequest.Header();
        header.setAppId(this.appId);
        header.setStatus(this.status);
        request.setHeader(header);
        SinoOCRRequest.Parameter parameter = new SinoOCRRequest.Parameter(this);
        request.setParameter(parameter);
        SinoOCRRequest.Payload payload = new SinoOCRRequest.Payload();
        SinoOCRRequest.Payload.Image image = new SinoOCRRequest.Payload.Image();
        image.setImage(imgBase64);
        image.setStatus(this.status);
        image.setEncoding(imgFormat);
        payload.setImage(image);
        request.setPayload(payload);
        String json = StringUtils.gson.toJson((Object)request);
        logger.debug("\u901a\u7528\u7968\u8bc1sinosecu\u8bc6\u522b\u8bf7\u6c42\u5165\u53c2: {}", (Object)json);
        return json;
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://api.xf-yun.com/v1/private/";
        private static final String SERVICE_ID = "sc45f0684";

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, SERVICE_ID, appId, apiKey, apiSecret);
            this.readTimeout(30);
        }

        public SinoOCRClient build() {
            return new SinoOCRClient(this);
        }
    }
}

