/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.common.request.RequestHeader;
import cn.xfyun.model.common.request.Result;
import cn.xfyun.model.document.PDRecParam;
import cn.xfyun.model.document.request.PDRecRequest;
import cn.xfyun.model.document.response.PDRecResponse;
import cn.xfyun.service.document.AbstractPDRecWebSocketListener;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.SignatureException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.Response;
import okhttp3.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDRecClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(PDRecClient.class);
    private final String category;
    private final String encoding;
    private final String compress;
    private final String format;

    public PDRecClient(Builder builder) {
        super((WebsocketBuilder)builder);
        this.originHostUrl = builder.hostUrl;
        this.category = builder.category;
        this.encoding = builder.encoding;
        this.compress = builder.compress;
        this.format = builder.format;
    }

    public String getCategory() {
        return this.category;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getCompress() {
        return this.compress;
    }

    public String getFormat() {
        return this.format;
    }

    public byte[] send(PDRecParam param) throws SignatureException, IOException {
        this.paramCheck(param);
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.newWebSocket(this.getWebSocketListener(param, future));
        return this.getBytes(future);
    }

    private byte[] getBytes(CompletableFuture<byte[]> future) throws SocketTimeoutException {
        try {
            return future.get(this.readTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new SocketTimeoutException("\u8bf7\u6c42\u8d85\u65f6");
        }
        catch (ExecutionException e) {
            throw new BusinessException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void paramCheck(PDRecParam param) {
        if (null == param) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNullOrEmpty((String)param.getImgBase64())) {
            throw new BusinessException("\u56fe\u7247\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNullOrEmpty((String)param.getResultType())) {
            throw new BusinessException("\u6587\u6863\u8bc6\u522b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNullOrEmpty((String)param.getImgFormat())) {
            throw new BusinessException("\u56fe\u7247\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private AbstractPDRecWebSocketListener getWebSocketListener(final PDRecParam param, final CompletableFuture<byte[]> future) throws IOException {
        return new AbstractPDRecWebSocketListener(param.getDstFile()){

            @Override
            public void onSuccess(byte[] bytes) {
                if (null != param.getDstFile()) {
                    logger.debug("File saved at: {}", (Object)param.getDstFile().getAbsolutePath());
                }
                future.complete(bytes);
            }

            @Override
            public void onClose(WebSocket webSocket, int code, String reason) {
                if (!future.isDone()) {
                    future.complete(new byte[0]);
                }
            }

            @Override
            public void onFail(WebSocket webSocket, Throwable t, Response response) {
                if (!future.isDone()) {
                    future.completeExceptionally(t);
                }
            }

            @Override
            public void onBusinessFail(WebSocket webSocket, PDRecResponse response) {
                String message = response.getHeader().getMessage();
                Integer code = response.getHeader().getCode();
                if (!future.isDone()) {
                    future.completeExceptionally(new Throwable(String.format("Error: %s (CODE=%s)", message, code)));
                }
                webSocket.close(1011, "\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
            }

            @Override
            public void onOpen(WebSocket webSocket, Response response) {
                webSocket.send(PDRecClient.this.getParam(param));
            }
        };
    }

    private String getParam(PDRecParam param) {
        PDRecRequest request = new PDRecRequest();
        RequestHeader header = new RequestHeader();
        header.setAppId(this.appId);
        header.setStatus(2);
        request.setHeader(header);
        PDRecRequest.Payload payload = new PDRecRequest.Payload();
        PDRecRequest.Payload.Test test = new PDRecRequest.Payload.Test();
        test.setEncoding(param.getImgFormat());
        test.setImage(param.getImgBase64());
        test.setStatus(3);
        payload.setTest(test);
        request.setPayload(payload);
        JsonObject parameter = new JsonObject();
        JsonObject innerParam1 = new JsonObject();
        JsonObject innerParam2 = new JsonObject();
        Result result = new Result(this.encoding, this.compress, this.format);
        innerParam1.addProperty("category", "ch_en_public_cloud");
        innerParam1.add("result", StringUtils.gson.toJsonTree((Object)result));
        parameter.add("s15282f39", (JsonElement)innerParam1);
        innerParam2.addProperty("result_type", param.getResultType());
        innerParam2.add("result", StringUtils.gson.toJsonTree((Object)result));
        parameter.add("s5eac762f", (JsonElement)innerParam2);
        JsonElement jsonTree = StringUtils.gson.toJsonTree((Object)request);
        jsonTree.getAsJsonObject().add("parameter", (JsonElement)parameter);
        logger.debug("\u56fe\u7247\u8f6c\u6587\u6863ws\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)jsonTree);
        return jsonTree.toString();
    }

    public static final class Builder
    extends WebsocketBuilder<Builder> {
        private String hostUrl = "https://ws-api.xf-yun.com/v1/private/ma008db16";
        private String category;
        private String encoding = "utf8";
        private String compress = "raw";
        private String format = "plain";

        public PDRecClient build() {
            return new PDRecClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret) {
            super.signature(appId, apiKey, apiSecret);
            super.readTimeout(60000L, TimeUnit.MILLISECONDS);
            super.writeTimeout(60000L, TimeUnit.MILLISECONDS);
            super.connectTimeout(60000L, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder compress(String compress) {
            this.compress = compress;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }
    }
}

