/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.IdcardEnum;
import cn.xfyun.config.IntsigRecgEnum;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntsigOcrClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(IntsigOcrClient.class);
    private final IntsigRecgEnum intsigRecgEnum;
    private final IdcardEnum headPortrait;
    private final IdcardEnum cropImage;
    private final IdcardEnum idNumberImage;
    private final IdcardEnum recognizeMode;

    public IdcardEnum getHeadPortrait() {
        return this.headPortrait;
    }

    public IdcardEnum getCropImage() {
        return this.cropImage;
    }

    public IdcardEnum getIdNumberImage() {
        return this.idNumberImage;
    }

    public IdcardEnum getRecognizeMode() {
        return this.recognizeMode;
    }

    public IntsigOcrClient(Builder builder) {
        super((HttpBuilder)builder);
        this.intsigRecgEnum = builder.intsigRecgEnum;
        this.headPortrait = builder.headPortrait;
        this.cropImage = builder.cropImage;
        this.idNumberImage = builder.idNumberImage;
        this.recognizeMode = builder.recognizeMode;
    }

    public String intsigRecg(String imageBase64) throws IOException {
        return this.intsigRecg(imageBase64, null);
    }

    public String intsigRecg(String imageBase64, String format) throws IOException {
        this.paramCheck(imageBase64);
        String body = this.buildParam(imageBase64, format);
        if (this.intsigRecgEnum.equals((Object)IntsigRecgEnum.COMMON_WORD)) {
            String signUrl = Signature.signHostDateAuthorization((String)("https://api.xf-yun.com/v1/private/" + this.intsigRecgEnum.getValue()), (String)"POST", (String)this.apiKey, (String)this.apiSecret);
            return this.sendPost(signUrl, JSON, body);
        }
        Map header = Signature.signHttpHeaderCheckSum((String)this.appId, (String)this.apiKey, (String)body);
        return this.sendPost(this.hostUrl + this.intsigRecgEnum.getValue(), FORM, header, "image=" + imageBase64);
    }

    private void paramCheck(String imageBase64) {
        if (StringUtils.isNullOrEmpty((String)imageBase64)) {
            throw new BusinessException("\u9700\u8981\u8bc6\u522b\u7684\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.intsigRecgEnum) {
            throw new BusinessException("\u8bc6\u522b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildParam(String imageBase64, String format) {
        JsonObject jsonObject = new JsonObject();
        if (this.intsigRecgEnum.equals((Object)IntsigRecgEnum.IDCARD)) {
            jsonObject.addProperty("engine_type", this.intsigRecgEnum.getValue());
            jsonObject.addProperty("head_portrait", this.headPortrait.getValue());
            jsonObject.addProperty("crop_image", this.cropImage.getValue());
            jsonObject.addProperty("id_number_image", this.idNumberImage.getValue());
            jsonObject.addProperty("recognize_mode", this.recognizeMode.getValue());
        } else if (this.intsigRecgEnum.equals((Object)IntsigRecgEnum.COMMON_WORD)) {
            JsonObject header = new JsonObject();
            header.addProperty("app_id", this.appId);
            header.addProperty("status", (Number)3);
            jsonObject.add("header", (JsonElement)header);
            JsonObject parameter = new JsonObject();
            JsonObject service = new JsonObject();
            JsonObject param = new JsonObject();
            param.addProperty("encoding", "utf8");
            param.addProperty("format", "json");
            param.addProperty("compress", "raw");
            service.add("recognizeDocumentRes", (JsonElement)param);
            parameter.add(this.intsigRecgEnum.getValue(), (JsonElement)service);
            jsonObject.add("parameter", (JsonElement)parameter);
            JsonObject payload = new JsonObject();
            JsonObject inputImage1 = new JsonObject();
            inputImage1.addProperty("encoding", format);
            inputImage1.addProperty("image", imageBase64);
            inputImage1.addProperty("status", (Number)3);
            payload.add("image", (JsonElement)inputImage1);
            jsonObject.add("payload", (JsonElement)payload);
        } else {
            jsonObject.addProperty("engine_type", this.intsigRecgEnum.getValue());
        }
        logger.debug("intsig{} \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)this.intsigRecgEnum.getName(), (Object)jsonObject);
        return jsonObject.toString();
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://webapi.xfyun.cn/v1/service/v1/ocr/";
        private static final String COMMON_WORD_URL = "https://api.xf-yun.com/v1/private/";
        private final IntsigRecgEnum intsigRecgEnum;
        private IdcardEnum headPortrait = IdcardEnum.OFF;
        private IdcardEnum cropImage = IdcardEnum.OFF;
        private IdcardEnum idNumberImage = IdcardEnum.OFF;
        private IdcardEnum recognizeMode = IdcardEnum.OFF;

        public Builder(String appId, String apiKey, IntsigRecgEnum intsigRecgEnum) {
            super(HOST_URL, appId, apiKey, null);
            this.intsigRecgEnum = intsigRecgEnum;
        }

        public Builder(String appId, String apiKey, String apiSecret, IntsigRecgEnum intsigRecgEnum) {
            super(HOST_URL, appId, apiKey, apiSecret);
            this.intsigRecgEnum = intsigRecgEnum;
        }

        public Builder headPortrait(IdcardEnum idcardEnum) {
            this.headPortrait = idcardEnum;
            return this;
        }

        public Builder cropImage(IdcardEnum idcardEnum) {
            this.cropImage = idcardEnum;
            return this;
        }

        public Builder idNumberImage(IdcardEnum idcardEnum) {
            this.idNumberImage = idcardEnum;
            return this;
        }

        public Builder recognizeMode(IdcardEnum idcardEnum) {
            this.recognizeMode = idcardEnum;
            return this;
        }

        public IntsigOcrClient build() {
            return new IntsigOcrClient(this);
        }
    }
}

