/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.config.ImageWordEnum;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageWordClient
extends PlatformHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(ImageWordClient.class);
    private final ImageWordEnum imageWordEnum;

    public ImageWordEnum getImageWordEnum() {
        return this.imageWordEnum;
    }

    public ImageWordClient(Builder builder) {
        super((PlatformBuilder)builder);
        this.imageWordEnum = builder.imageWordEnum;
    }

    public String imageWord(String imageBase64, String format) throws IOException {
        String signUrl = Signature.signHostDateAuthorization((String)(this.hostUrl + this.serviceId), (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        String body = this.bodyParam(imageBase64, format);
        return this.sendPost(signUrl, JSON, body);
    }

    private String bodyParam(String imageBase64, String encoding) {
        if (null == this.imageWordEnum) {
            throw new BusinessException("\u8bc6\u522b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JsonObject jso = new JsonObject();
        jso.add("header", (JsonElement)this.buildHeader());
        JsonObject parameter = new JsonObject();
        JsonObject service = new JsonObject();
        service.add("result", (JsonElement)this.buildResult());
        if (this.imageWordEnum.equals((Object)ImageWordEnum.COMMON_WORD)) {
            service.addProperty("category", "ch_en_public_cloud");
        } else if (this.imageWordEnum.equals((Object)ImageWordEnum.PRINTED_WORD)) {
            service.addProperty("category", "mix0");
        } else {
            service.addProperty("template_list", this.imageWordEnum.getTemplateList());
        }
        parameter.add(this.serviceId, (JsonElement)service);
        jso.add("parameter", (JsonElement)parameter);
        JsonObject payload = new JsonObject();
        JsonObject inputImage1 = new JsonObject();
        inputImage1.addProperty("encoding", encoding);
        inputImage1.addProperty("image", imageBase64);
        inputImage1.addProperty("status", (Number)this.status);
        payload.add(this.imageWordEnum.getPayload(), (JsonElement)inputImage1);
        jso.add("payload", (JsonElement)payload);
        logger.debug("{} \u8bf7\u6c42\u5165\u53c2: {}", (Object)this.imageWordEnum.getName(), (Object)jso);
        return jso.toString();
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://api.xf-yun.com/v1/private/";
        private final ImageWordEnum imageWordEnum;

        public Builder(String appId, String apiKey, String apiSecret, ImageWordEnum imageWordEnum) {
            super(HOST_URL, imageWordEnum.getServiceId(), appId, apiKey, apiSecret);
            this.imageWordEnum = imageWordEnum;
        }

        public ImageWordClient build() {
            return new ImageWordClient(this);
        }
    }
}

