/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.LanguageEnum;
import cn.xfyun.config.LocationEnum;
import cn.xfyun.config.OcrWordsEnum;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;

public class GeneralWordsClient
extends HttpClient {
    private OcrWordsEnum ocrTypeEnum;
    private LanguageEnum language;
    private LocationEnum location;

    public LanguageEnum getLanguage() {
        return this.language;
    }

    public LocationEnum getLocation() {
        return this.location;
    }

    public GeneralWordsClient(Builder builder) {
        super((HttpBuilder)builder);
        this.ocrTypeEnum = builder.ocrTypeEnum;
        this.language = builder.language;
        this.location = builder.location;
    }

    public String generalWords(String imageBase64) throws IOException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("language", this.language.getValue());
        jsonObject.addProperty("location", this.location.getValue());
        Map header = Signature.signHttpHeaderCheckSum((String)this.appId, (String)this.apiKey, (String)jsonObject.toString());
        return this.sendPost(this.hostUrl + this.ocrTypeEnum.getValue(), FORM, header, "image=" + imageBase64);
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://webapi.xfyun.cn/v1/service/v1/ocr/";
        private OcrWordsEnum ocrTypeEnum;
        private LanguageEnum language = LanguageEnum.CN;
        private LocationEnum location = LocationEnum.OFF;

        public Builder language(LanguageEnum language) {
            this.language = language;
            return this;
        }

        public Builder location(LocationEnum location) {
            this.location = location;
            return this;
        }

        public Builder(String appId, String apiKey, OcrWordsEnum ocrTypeEnum) {
            super(HOST_URL, appId, apiKey, null);
            this.ocrTypeEnum = ocrTypeEnum;
        }

        public GeneralWordsClient build() {
            return new GeneralWordsClient(this);
        }
    }
}

