/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

public class FingerOcrClient
extends HttpClient {
    private float cutWScale;
    private float cutHScale;
    private float cutShift;
    private int resizeW;
    private int resizeH;

    public float getCutWScale() {
        return this.cutWScale;
    }

    public float getCutHScale() {
        return this.cutHScale;
    }

    public float getCutShift() {
        return this.cutShift;
    }

    public int getResizeW() {
        return this.resizeW;
    }

    public int getResizeH() {
        return this.resizeH;
    }

    public FingerOcrClient(Builder builder) {
        super((HttpBuilder)builder);
        this.cutHScale = builder.cutHScale;
        this.cutWScale = builder.cutWScale;
        this.cutShift = builder.cutShift;
        this.resizeH = builder.resizeH;
        this.resizeW = builder.resizeW;
    }

    public String fingerOcr(String imageBase64) throws Exception {
        String body = this.buildHttpBody(imageBase64);
        Map header = Signature.signHttpHeaderDigest((String)this.hostUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret, (String)body);
        return this.sendPost(this.hostUrl, JSON, header, body);
    }

    private String buildHttpBody(String imageBase64) {
        JsonObject body = new JsonObject();
        JsonObject business = new JsonObject();
        JsonObject common = new JsonObject();
        JsonObject data = new JsonObject();
        common.addProperty("app_id", this.appId);
        business.addProperty("ent", "fingerocr");
        business.addProperty("mode", "finger+ocr");
        business.addProperty("method", "dynamic");
        business.addProperty("cut_w_scale", (Number)Float.valueOf(this.cutWScale));
        business.addProperty("cut_h_scale", (Number)Float.valueOf(this.cutHScale));
        business.addProperty("cut_shift", (Number)Float.valueOf(this.cutShift));
        business.addProperty("resize_w", (Number)this.resizeW);
        business.addProperty("resize_h", (Number)this.resizeH);
        data.addProperty("image", imageBase64);
        body.add("common", (JsonElement)common);
        body.add("business", (JsonElement)business);
        body.add("data", (JsonElement)data);
        return body.toString();
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://tyocr.xfyun.cn/v2/ocr";
        private float cutWScale = 3.0f;
        private float cutHScale = 2.0f;
        private float cutShift = 0.3f;
        private int resizeW = 1088;
        private int resizeH = 1632;

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, appId, apiKey, apiSecret);
        }

        public Builder cutWScale(float cutWScale) {
            this.cutWScale = cutWScale;
            return this;
        }

        public Builder cutHScale(float cutHScale) {
            this.cutHScale = cutHScale;
            return this;
        }

        public Builder cutShift(float cutShift) {
            this.cutShift = cutShift;
            return this;
        }

        public Builder resizeW(int resizeW) {
            this.resizeW = resizeW;
            return this;
        }

        public Builder resizeH(int resizeH) {
            this.resizeH = resizeH;
            return this;
        }

        public FingerOcrClient build() {
            return new FingerOcrClient(this);
        }
    }
}

