/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;

public class BusinessCardClient
extends HttpClient {
    private static final String BUSINESS_CARD = "business_card";
    private String picRequired;

    public BusinessCardClient(Builder builder) {
        super((HttpBuilder)builder);
        this.picRequired = builder.picRequired;
    }

    public String businessCard(String imageBase64) throws IOException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("engine_type", BUSINESS_CARD);
        jsonObject.addProperty("pic_required", this.picRequired);
        Map header = Signature.signHttpHeaderCheckSum((String)this.appId, (String)this.apiKey, (String)jsonObject.toString());
        return this.sendPost(this.hostUrl, FORM, header, "image=" + imageBase64);
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://webapi.xfyun.cn/v1/service/v1/ocr/business_card";
        private String picRequired = "0";

        public Builder(String appId, String apiKey) {
            super(HOST_URL, appId, apiKey, null);
        }

        public Builder picRequired() {
            this.picRequired = "1";
            return this;
        }

        public BusinessCardClient build() {
            return new BusinessCardClient(this);
        }
    }
}

