/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.simult;

import cn.xfyun.model.simult.response.SimInterpResponse;
import cn.xfyun.util.StringUtils;
import javax.annotation.Nullable;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimInterpWebSocketListener
extends WebSocketListener {
    private static final Logger logger = LoggerFactory.getLogger(SimInterpWebSocketListener.class);

    public abstract void onSuccess(WebSocket var1, SimInterpResponse var2);

    public abstract void onFail(WebSocket var1, Throwable var2, Response var3);

    public abstract void onClose(WebSocket var1, int var2, String var3);

    public abstract void onConnect(WebSocket var1, Response var2);

    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
        logger.info("webSocket is open");
        this.onConnect(webSocket, response);
    }

    public void onMessage(WebSocket webSocket, String text) {
        super.onMessage(webSocket, text);
        try {
            if (text != null) {
                SimInterpResponse sparkIatResponse = (SimInterpResponse)StringUtils.gson.fromJson(text, SimInterpResponse.class);
                if (sparkIatResponse != null) {
                    this.onSuccess(webSocket, sparkIatResponse);
                } else {
                    this.onSuccess(webSocket, new SimInterpResponse(-1, "SimInterp response error"));
                }
            }
        }
        catch (Exception e) {
            logger.error("parse text to object fail ,text is [{}]", (Object)text, (Object)e);
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        super.onMessage(webSocket, bytes);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
        logger.warn("webSocket is closing ,code is {} , reason is [{}]", (Object)code, (Object)reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        super.onClosed(webSocket, code, reason);
        logger.warn("webSocket is closed ,code is {} , reason is [{}]", (Object)code, (Object)reason);
        this.onClose(webSocket, code, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
        super.onFailure(webSocket, t, response);
        try {
            this.onFail(webSocket, t, response);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception closeError) {
                    logger.warn("response close failed", (Throwable)closeError);
                }
            }
        }
    }
}

