/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.simult;

import cn.xfyun.api.SimInterpClient;
import cn.xfyun.model.simult.request.SimInterpRequest;
import cn.xfyun.service.common.AbstractNlpTask;
import cn.xfyun.util.StringUtils;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimInterpSendTask
extends AbstractNlpTask {
    private static final Logger logger = LoggerFactory.getLogger(SimInterpSendTask.class);
    private static final int STATUS_FIRST_FRAME = 0;
    private static final int STATUS_CONTINUED_FRAME = 1;
    private static final int STATUS_LAST_FRAME = 2;
    private int status = 0;
    private SimInterpClient simInterpClient = null;

    @Override
    public String businessDataProcess(byte[] contents, boolean isEnd, Integer seq) {
        if (isEnd) {
            this.status = 2;
        }
        SimInterpRequest request = new SimInterpRequest();
        SimInterpRequest.Header header = new SimInterpRequest.Header(this.client().getAppId(), this.status);
        request.setHeader(header);
        SimInterpRequest.Payload payload = new SimInterpRequest.Payload();
        SimInterpRequest.Payload.Data data = new SimInterpRequest.Payload.Data();
        data.setSampleRate(this.client().getSampleRate());
        data.setEncoding(this.client().getEncoding());
        data.setSeq(seq);
        data.setStatus(0);
        if (contents == null || contents.length == 0) {
            data.setAudio("");
        } else {
            data.setAudio(Base64.getEncoder().encodeToString(contents));
        }
        payload.setData(data);
        request.setPayload(payload);
        switch (this.status) {
            case 0: {
                SimInterpRequest.Parameter parameter = new SimInterpRequest.Parameter(this.client());
                request.setParameter(parameter);
                this.status = 1;
                String first = StringUtils.gson.toJson((Object)request);
                logger.debug("\u53d1\u9001\u7b2c\u4e00\u5e27\u6570\u636e\uff1a{}", (Object)first);
                return first;
            }
            case 1: {
                String continued = StringUtils.gson.toJson((Object)request);
                logger.debug("\u53d1\u9001\u4e2d\u95f4\u5e27\u6570\u636e\uff1a{}", (Object)continued);
                return continued;
            }
            case 2: {
                String last = StringUtils.gson.toJson((Object)request);
                logger.debug("\u53d1\u9001\u6700\u540e\u4e00\u5e27\u6570\u636e\uff1a{}", (Object)last);
                return last;
            }
        }
        return null;
    }

    private SimInterpClient client() {
        if (this.simInterpClient == null) {
            this.simInterpClient = (SimInterpClient)this.client;
            return this.simInterpClient;
        }
        return this.simInterpClient;
    }
}

