/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.common;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.util.IOCloseUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import okhttp3.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNlpTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNlpTask.class);
    protected AbstractClient client;
    protected WebSocket webSocket;
    private Integer waitMillis = 40;
    private byte[] bytes;
    private InputStream inputStream;
    private Closeable closeable;
    private Integer frameSize = 1280;
    private boolean isDataEnd = false;

    public AbstractNlpTask build(Builder builder) {
        this.waitMillis = builder.waitMillis;
        this.bytes = builder.bytes;
        this.closeable = builder.closeable;
        this.inputStream = builder.inputStream;
        this.frameSize = builder.frameSize;
        this.client = builder.client;
        this.webSocket = builder.webSocket;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            try {
                byte[] buffer = new byte[this.frameSize.intValue()];
                if (this.inputStream != null) {
                    int seq = 0;
                    do {
                        ++seq;
                        int readLength = this.inputStream.read(buffer);
                        if (readLength == -1) {
                            this.isDataEnd = true;
                        }
                        String data = this.businessDataProcess(this.isDataEnd ? null : Arrays.copyOf(buffer, readLength), this.isDataEnd, seq);
                        this.webSocket.send(data);
                        TimeUnit.MILLISECONDS.sleep(this.waitMillis.intValue());
                    } while (!this.isDataEnd);
                    break block10;
                }
                if (this.bytes == null || this.bytes.length <= 0) break block10;
                int byteLen = this.bytes.length;
                int seq = 0;
                int startIndex = 0;
                while (true) {
                    String data;
                    byte[] contents;
                    ++seq;
                    if (startIndex + this.frameSize >= byteLen) {
                        contents = Arrays.copyOfRange(this.bytes, startIndex, byteLen);
                        data = this.businessDataProcess(contents, true, seq);
                        this.webSocket.send(data);
                        logger.info("\u6570\u636e\u53d1\u9001\u5b8c\u6bd5!");
                        break;
                    }
                    contents = Arrays.copyOfRange(this.bytes, startIndex, startIndex + this.frameSize);
                    data = this.businessDataProcess(contents, false, seq);
                    this.webSocket.send(data);
                    TimeUnit.MILLISECONDS.sleep(this.waitMillis.intValue());
                    startIndex += this.frameSize.intValue();
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u6570\u636e\u5f02\u5e38", (Throwable)e);
            }
            finally {
                IOCloseUtil.close((Closeable)this.closeable);
                IOCloseUtil.close((Closeable)this.inputStream);
            }
        }
    }

    public abstract String businessDataProcess(byte[] var1, boolean var2, Integer var3) throws InterruptedException;

    public static final class Builder {
        private Integer waitMillis = 40;
        private AbstractClient client;
        private WebSocket webSocket;
        private byte[] bytes;
        private Closeable closeable;
        private InputStream inputStream;
        private Integer frameSize = 1280;

        public Builder waitMillis(Integer waitMills) {
            this.waitMillis = waitMills;
            return this;
        }

        public Builder client(AbstractClient client) {
            this.client = client;
            return this;
        }

        public Builder webSocket(WebSocket webSocket) {
            this.webSocket = webSocket;
            return this;
        }

        public Builder bytes(byte[] bytes) {
            this.bytes = bytes;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder closeable(Closeable closeable) {
            this.closeable = closeable;
            return this;
        }

        public Builder frameSize(Integer frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        public void build(AbstractNlpTask task) {
            task.build(this);
        }
    }
}

