/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.WordLibEnum;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.SignatureException;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordLibClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(WordLibClient.class);

    public WordLibClient(Builder builder) {
        super((HttpBuilder)builder);
    }

    public String createBlackLib(String name, String category, String suggestion) throws IOException, SignatureException {
        return this.createLib(name, category, suggestion, true);
    }

    public String createWhiteLib(String name) throws IOException, SignatureException {
        return this.createLib(name, null, null, false);
    }

    public String addWord(String libId, List<String> wordList) throws IOException, SignatureException {
        if (StringUtils.isNullOrEmpty((String)libId) || wordList == null || wordList.isEmpty()) {
            throw new BusinessException("\u8bcd\u5e93ID\u6216\u8bcd\u6761\u5217\u8868\u4e3a\u7a7a");
        }
        JsonObject param = new JsonObject();
        param.addProperty("lib_id", libId);
        param.add("word_list", StringUtils.gson.toJsonTree(wordList));
        logger.debug("\u6dfb\u52a0\u8bcd\u6761\u8bf7\u6c42\u5165\u53c2: {}", (Object)param);
        return this.send(WordLibEnum.ADD_WORD, param.toString());
    }

    public String delWord(String libId, List<String> wordList) throws IOException, SignatureException {
        if (StringUtils.isNullOrEmpty((String)libId) || wordList == null || wordList.isEmpty()) {
            throw new BusinessException("\u8bcd\u5e93ID\u6216\u8bcd\u6761\u5217\u8868\u4e3a\u7a7a");
        }
        JsonObject param = new JsonObject();
        param.addProperty("lib_id", libId);
        param.add("word_list", StringUtils.gson.toJsonTree(wordList));
        logger.debug("\u5220\u9664\u8bcd\u6761\u8bf7\u6c42\u5165\u53c2: {}", (Object)param);
        return this.send(WordLibEnum.DEL_WORD, param.toString());
    }

    public String info(String libId, boolean returnWord) throws IOException, SignatureException {
        if (StringUtils.isNullOrEmpty((String)libId)) {
            throw new BusinessException("\u8bcd\u5e93ID\u4e3a\u7a7a");
        }
        JsonObject param = new JsonObject();
        param.addProperty("lib_id", libId);
        param.addProperty("return_word", Boolean.valueOf(returnWord));
        logger.debug("\u67e5\u8be2\u8bcd\u6761\u660e\u7ec6\u8bf7\u6c42\u5165\u53c2: {}", (Object)param);
        return this.send(WordLibEnum.INFO, param.toString());
    }

    public String info(String libId) throws Exception {
        return this.info(libId, true);
    }

    public String listLib() throws IOException, SignatureException {
        return this.send(WordLibEnum.LIST, "{}");
    }

    public String deleteLib(String libId) throws IOException, SignatureException {
        JsonObject param = new JsonObject();
        param.addProperty("lib_id", libId);
        logger.debug("\u5220\u9664\u8bcd\u5e93\u8bf7\u6c42\u5165\u53c2: {}", (Object)param);
        return this.send(WordLibEnum.DEL_LIB, param.toString());
    }

    private String createLib(String name, String category, String suggestion, boolean black) throws IOException, SignatureException {
        if ((StringUtils.isNullOrEmpty((String)name) || StringUtils.isNullOrEmpty((String)category)) && black) {
            throw new BusinessException("\u8bcd\u5e93\u540d\u79f0\u6216\u8bcd\u5e93\u7b56\u7565\u4e3a\u7a7a");
        }
        JsonObject param = new JsonObject();
        param.addProperty("name", name);
        param.addProperty("category", category);
        param.addProperty("suggestion", StringUtils.isNullOrEmpty((String)suggestion) ? "block" : suggestion);
        logger.debug("\u521b\u5efa\u8bcd\u5e93\u8bf7\u6c42\u5165\u53c2: {}", (Object)param);
        return this.send(black ? WordLibEnum.CREATE_BLACK : WordLibEnum.CREATE_WHITE, param.toString());
    }

    private String send(WordLibEnum wordLibEnum, String param) throws IOException, SignatureException {
        Map parameters = Signature.getAuth((String)this.appId, (String)this.apiKey, (String)this.apiSecret);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)param);
        return this.sendPost(this.hostUrl + wordLibEnum.getUrl(), null, body, parameters);
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://audit.iflyaisol.com/audit_res/v1";

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, appId, apiKey, apiSecret);
        }

        public WordLibClient build() {
            return new WordLibClient(this);
        }
    }
}

