/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.Video;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.SignatureException;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoComplianceClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(VideoComplianceClient.class);
    private final String notifyUrl;
    private final String queryUrl;

    public VideoComplianceClient(Builder builder) {
        super((HttpBuilder)builder);
        this.notifyUrl = builder.notifyUrl;
        this.queryUrl = builder.queryUrl;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String send(List<Video> videoList) throws Exception {
        return this.send(videoList, null);
    }

    public String send(List<Video> videoList, String notifyUrl) throws IOException, SignatureException {
        this.paramCheck(videoList);
        Map parameters = Signature.getAuth((String)this.appId, (String)this.apiKey, (String)this.apiSecret);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.buildParam(videoList, notifyUrl));
        return this.sendPost(this.hostUrl, null, body, parameters);
    }

    public String query(String requestId) throws IOException, SignatureException {
        this.queryCheck(requestId);
        Map parameters = Signature.getAuth((String)this.appId, (String)this.apiKey, (String)this.apiSecret);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.buildQuery(requestId));
        return this.sendPost(this.queryUrl, null, body, parameters);
    }

    private String buildQuery(String requestId) {
        JsonObject param = new JsonObject();
        param.addProperty("request_id", requestId);
        return param.toString();
    }

    private void queryCheck(String requestId) {
        if (StringUtils.isNullOrEmpty((String)requestId)) {
            throw new BusinessException("requestId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void paramCheck(List<Video> videoList) {
        if (null == videoList || videoList.isEmpty()) {
            throw new BusinessException("\u89c6\u9891\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildParam(List<Video> videoList, String callBackUrl) {
        JsonObject json = new JsonObject();
        json.add("video_list", StringUtils.gson.toJsonTree(videoList));
        json.addProperty("notify_url", StringUtils.isNullOrEmpty((String)callBackUrl) ? this.notifyUrl : callBackUrl);
        logger.debug("\u89c6\u9891\u5408\u89c4\u8bf7\u6c42\u53c2\u6570: {}", (Object)json);
        return json.toString();
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://audit.iflyaisol.com/audit/v2/video";
        private String notifyUrl;
        private String queryUrl = "https://audit.iflyaisol.com/audit/v2/query";

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, appId, apiKey, apiSecret);
        }

        public VideoComplianceClient build() {
            return new VideoComplianceClient(this);
        }

        public Builder notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public Builder queryUrl(String queryUrl) {
            this.queryUrl = queryUrl;
            return this;
        }
    }
}

