/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.model.translate.TransParam;
import cn.xfyun.model.translate.request.TransV2Request;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(TransClient.class);
    private final String from;
    private final String to;
    private final String resId;
    private final String itsServerUrl;
    private final String itsV2ServerUrl;
    private final String niuServerUrl;

    public TransClient(Builder builder) {
        super((HttpBuilder)builder);
        this.from = builder.from;
        this.to = builder.to;
        this.resId = builder.resId;
        this.itsServerUrl = builder.itsServerUrl;
        this.itsV2ServerUrl = builder.itsV2ServerUrl;
        this.niuServerUrl = builder.niuServerUrl;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getResId() {
        return this.resId;
    }

    public String getItsServerUrl() {
        return this.itsServerUrl;
    }

    public String getItsV2ServerUrl() {
        return this.itsV2ServerUrl;
    }

    public String getNiuServerUrl() {
        return this.niuServerUrl;
    }

    public String sendIst(String text) throws Exception {
        TransParam param = TransParam.builder().text(text).build();
        return this.send(this.itsServerUrl, param);
    }

    public String sendIst(TransParam param) throws Exception {
        return this.send(this.itsServerUrl, param);
    }

    public String sendIstV2(TransParam param) throws Exception {
        this.paramCheck(param);
        String body = this.builtV2Body(param);
        String realUrl = Signature.signHostDateAuthorization((String)this.itsV2ServerUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        return this.sendPost(realUrl, JSON, null, body);
    }

    public String sendIstV2(String text) throws Exception {
        TransParam param = TransParam.builder().text(text).build();
        return this.sendIstV2(param);
    }

    public String sendNiuTrans(String text) throws Exception {
        TransParam param = TransParam.builder().text(text).build();
        return this.send(this.niuServerUrl, param);
    }

    public String sendNiuTrans(TransParam param) throws Exception {
        return this.send(this.niuServerUrl, param);
    }

    private void paramCheck(TransParam param) {
        if (null == param) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNullOrEmpty((String)param.getText())) {
            throw new BusinessException("\u7ffb\u8bd1\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String send(String url, TransParam param) throws IOException, SignatureException {
        this.paramCheck(param);
        try {
            String body = this.buildV1Body(param);
            Map header = Signature.signHttpHeaderDigest((String)url, (String)"POST", (String)this.apiKey, (String)this.apiSecret, (String)body);
            return this.sendPost(url, JSON, header, body);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("InvalidKeyException:" + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException("NoSuchAlgorithmException:" + e.getMessage());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String buildV1Body(TransParam param) {
        JsonObject body = new JsonObject();
        JsonObject business = new JsonObject();
        JsonObject common = new JsonObject();
        JsonObject data = new JsonObject();
        common.addProperty("app_id", this.appId);
        business.addProperty("from", StringUtils.isNullOrEmpty((String)param.getFrom()) ? this.from : param.getFrom());
        business.addProperty("to", StringUtils.isNullOrEmpty((String)param.getTo()) ? this.to : param.getTo());
        data.addProperty("text", Base64.getEncoder().encodeToString(param.getText().getBytes(StandardCharsets.UTF_8)));
        body.add("common", (JsonElement)common);
        body.add("business", (JsonElement)business);
        body.add("data", (JsonElement)data);
        logger.debug("\u7ffb\u8bd1\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)body);
        return body.toString();
    }

    private String builtV2Body(TransParam param) {
        TransV2Request request = new TransV2Request();
        TransV2Request.Header header = new TransV2Request.Header();
        header.setAppId(this.appId);
        header.setStatus(3);
        header.setResId(StringUtils.isNullOrEmpty((String)param.getResId()) ? this.resId : param.getResId());
        request.setHeader(header);
        TransV2Request.Parameter parameter = new TransV2Request.Parameter();
        TransV2Request.Parameter.Its its = new TransV2Request.Parameter.Its();
        its.setFrom(StringUtils.isNullOrEmpty((String)param.getFrom()) ? this.from : param.getFrom());
        its.setTo(StringUtils.isNullOrEmpty((String)param.getTo()) ? this.to : param.getTo());
        its.setResult(new Object());
        parameter.setIts(its);
        request.setParameter(parameter);
        TransV2Request.Payload payload = new TransV2Request.Payload();
        TransV2Request.Payload.InputData inputData = new TransV2Request.Payload.InputData();
        inputData.setEncoding("utf8");
        inputData.setStatus(3);
        inputData.setText(Base64.getEncoder().encodeToString(param.getText().getBytes(StandardCharsets.UTF_8)));
        payload.setInputData(inputData);
        request.setPayload(payload);
        String requestStr = StringUtils.gson.toJson((Object)request);
        logger.debug("\u65b0\u7248\u672c\u7ffb\u8bd1\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)requestStr);
        return requestStr;
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private String itsServerUrl = "https://itrans.xfyun.cn/v2/its";
        private String itsV2ServerUrl = "https://itrans.xf-yun.com/v1/its";
        private String niuServerUrl = "https://ntrans.xfyun.cn/v2/ots";
        private String from = "cn";
        private String to = "en";
        private String resId;

        public Builder(String appId, String apiKey, String apiSecret) {
            super("", appId, apiKey, apiSecret);
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder resId(String resId) {
            this.resId = resId;
            return this;
        }

        public Builder itsServerUrl(String itsServerUrl) {
            this.itsServerUrl = itsServerUrl;
            return this;
        }

        public Builder itsV2ServerUrl(String itsV2ServerUrl) {
            this.itsV2ServerUrl = itsV2ServerUrl;
            return this;
        }

        public Builder niuServerUrl(String niuServerUrl) {
            this.niuServerUrl = niuServerUrl;
            return this;
        }

        @Deprecated
        public Builder hostUrl(String hostUrl) {
            return (Builder)((Object)super.hostUrl(hostUrl));
        }

        public TransClient build() {
            return new TransClient(this);
        }
    }
}

