/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.model.textrewrite.TextReWriteRequest;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextRewriteClient
extends PlatformHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(TextRewriteClient.class);
    private final String level;

    public String getLevel() {
        return this.level;
    }

    public TextRewriteClient(Builder builder) {
        super((PlatformBuilder)builder);
        this.level = builder.level;
    }

    public String send(String text) throws IOException {
        return this.send(text, null);
    }

    public String send(String text, String level) throws IOException {
        if (StringUtils.isNullOrEmpty((String)text)) {
            throw new BusinessException("text\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String realUrl = Signature.signHostDateAuthorization((String)this.hostUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        String body = this.buildParam(text, level);
        return this.sendPost(realUrl, JSON, null, body);
    }

    private String buildParam(String text, String level) {
        TextReWriteRequest request = new TextReWriteRequest();
        TextReWriteRequest.Header header = new TextReWriteRequest.Header(this.appId, this.status);
        request.setHeader(header);
        JsonObject parameter = new JsonObject();
        TextReWriteRequest.ServiceModel serviceModel = new TextReWriteRequest.ServiceModel(this);
        serviceModel.setLevel(String.format("<%s>", null == level ? this.level : level));
        parameter.add(this.serviceId, StringUtils.gson.toJsonTree((Object)serviceModel));
        TextReWriteRequest.Payload payload = new TextReWriteRequest.Payload(this);
        payload.getInput().setText(Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8)));
        request.setPayload(payload);
        JsonObject requestObj = StringUtils.gson.toJsonTree((Object)request).getAsJsonObject();
        requestObj.add("parameter", (JsonElement)parameter);
        String requestStr = requestObj.toString();
        logger.debug("\u6587\u672c\u6539\u5199 API \u5165\u53c2\uff1a{}", (Object)requestStr);
        return requestStr;
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://api.xf-yun.com/v1/private/se3acbe7f";
        private static final String SERVICE_ID = "se3acbe7f";
        private String level = "L1";

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, SERVICE_ID, appId, apiKey, apiSecret);
        }

        public TextRewriteClient build() {
            return new TextRewriteClient(this);
        }

        public Builder level(String level) {
            this.level = level;
            return this;
        }
    }
}

