/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.model.textproof.request.TextProofreadRequest;
import cn.xfyun.util.StringUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextProofreadClient
extends PlatformHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(TextProofreadClient.class);

    public TextProofreadClient(Builder builder) {
        super((PlatformBuilder)builder);
    }

    public String send(String text) throws IOException {
        if (StringUtils.isNullOrEmpty((String)text)) {
            throw new BusinessException("text\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String realUrl = Signature.signHostDateAuthorization((String)this.hostUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        return this.sendPost(realUrl, JSON, null, this.buildParam(text));
    }

    private String buildParam(String text) {
        TextProofreadRequest request = new TextProofreadRequest();
        TextProofreadRequest.Header header = new TextProofreadRequest.Header();
        header.setAppId(this.appId);
        header.setStatus(this.status);
        request.setHeader(header);
        TextProofreadRequest.Parameter parameter = new TextProofreadRequest.Parameter(this);
        request.setParameter(parameter);
        TextProofreadRequest.Payload payload = new TextProofreadRequest.Payload(this);
        payload.getText().setText(Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8)));
        request.setPayload(payload);
        String requestStr = StringUtils.gson.toJson((Object)request);
        logger.debug("\u6587\u672c\u6821\u5bf9 API \u5165\u53c2\uff1a{}", (Object)requestStr);
        return requestStr;
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://cn-huadong-1.xf-yun.com/v1/private/s37b42a45";
        private static final String SERVICE_ID = "s37b42a45";

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, SERVICE_ID, appId, apiKey, apiSecret);
        }

        public TextProofreadClient build() {
            return new TextProofreadClient(this);
        }
    }
}

