/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.compliance.text.TextCompParam;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.util.StringUtils;
import java.io.IOException;
import java.security.SignatureException;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextComplianceClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(TextComplianceClient.class);
    private final int isMatchAll;
    private final List<String> categories;
    private final List<String> libIds;

    public TextComplianceClient(Builder builder) {
        super((HttpBuilder)builder);
        this.isMatchAll = builder.isMatchAll;
        this.categories = builder.categories;
        this.libIds = builder.libIds;
    }

    public int getIsMatchAll() {
        return this.isMatchAll;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<String> getLibIds() {
        return this.libIds;
    }

    public String send(TextCompParam param) throws SignatureException, IOException {
        this.paramCheck(param);
        Map parameters = Signature.getAuth((String)this.appId, (String)this.apiKey, (String)this.apiSecret);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.paramHandler(param));
        return this.sendPost(this.hostUrl, null, body, parameters);
    }

    private void paramCheck(TextCompParam param) {
        if (param == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        param.selfCheck();
    }

    private String paramHandler(TextCompParam param) {
        if (null == param.getIsMatchAll()) {
            param.setIsMatchAll(this.isMatchAll);
        }
        if (null == param.getCategories()) {
            param.setCategories(this.categories);
        }
        if (null == param.getLibIds()) {
            param.setLibIds(this.libIds);
        }
        String json = StringUtils.gson.toJson((Object)param);
        logger.debug("\u6587\u672c\u5408\u89c4\u8bf7\u6c42\u53c2\u6570: {}", (Object)json);
        return json;
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://audit.iflyaisol.com/audit/v2/syncText";
        private int isMatchAll = 0;
        private List<String> categories;
        private List<String> libIds;

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, appId, apiKey, apiSecret);
        }

        public TextComplianceClient build() {
            return new TextComplianceClient(this);
        }

        public Builder isMatchAll(int isMatchAll) {
            this.isMatchAll = isMatchAll;
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            return this;
        }

        public Builder libIds(List<String> libIds) {
            this.libIds = libIds;
            return this;
        }
    }
}

