/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Base64;

public class TextCheckClient
extends PlatformHttpClient {
    public TextCheckClient(Builder builder) {
        super((PlatformBuilder)builder);
    }

    public String send(String text) throws Exception {
        if (StringUtils.isNullOrEmpty((String)text)) {
            throw new BusinessException("text\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String realUrl = Signature.signHostDateAuthorization((String)this.hostUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        return this.sendPost(realUrl, JSON, null, this.buildParam(text));
    }

    private String buildParam(String text) throws IOException {
        JsonObject req = new JsonObject();
        req.add("header", (JsonElement)this.buildHeader());
        JsonObject parameter = new JsonObject();
        JsonObject result = new JsonObject();
        result.add("result", (JsonElement)this.buildResult());
        parameter.add(this.serviceId, (JsonElement)result);
        JsonObject payload = new JsonObject();
        JsonObject input = new JsonObject();
        input.addProperty("encoding", this.encoding);
        input.addProperty("compress", this.compress);
        input.addProperty("format", this.format);
        input.addProperty("status", (Number)this.status);
        input.addProperty("text", Base64.getEncoder().encodeToString(text.getBytes("UTF-8")));
        payload.add("input", (JsonElement)input);
        req.add("parameter", (JsonElement)parameter);
        req.add("payload", (JsonElement)payload);
        return req.toString();
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://api.xf-yun.com/v1/private/s9a87e3ec";
        private static final String SERVICE_ID = "s9a87e3ec";

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, SERVICE_ID, appId, apiKey, apiSecret);
        }

        public TextCheckClient build() {
            TextCheckClient client = new TextCheckClient(this);
            return client;
        }
    }
}

