/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.model.simult.request.SimInterpRequest;
import cn.xfyun.service.common.AbstractNlpTask;
import cn.xfyun.service.simult.SimInterpSendTask;
import cn.xfyun.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.SignatureException;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimInterpClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(SimInterpClient.class);
    private final ExecutorService executor;
    private final String language;
    private final int languageType;
    private final String domain;
    private final String accent;
    private final Integer eos;
    private final Integer vto;
    private final Integer nunum;
    private final String from;
    private final String to;
    private final String vcn;
    private final String encoding;
    private final int sampleRate;
    private final int channels;
    private final int bitDepth;

    public SimInterpClient(Builder builder) {
        super((WebsocketBuilder)builder);
        this.originHostUrl = builder.hostUrl;
        this.language = builder.language;
        this.languageType = builder.languageType;
        this.domain = builder.domain;
        this.accent = builder.accent;
        this.eos = builder.eos;
        this.vto = builder.vto;
        this.nunum = builder.nunum;
        this.from = builder.from;
        this.to = builder.to;
        this.vcn = builder.vcn;
        this.encoding = builder.encoding;
        this.sampleRate = builder.sampleRate;
        this.channels = builder.channels;
        this.bitDepth = builder.bitDepth;
        this.executor = null == builder.executor ? Executors.newSingleThreadExecutor() : builder.executor;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getLanguageType() {
        return this.languageType;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAccent() {
        return this.accent;
    }

    public Integer getEos() {
        return this.eos;
    }

    public Integer getVto() {
        return this.vto;
    }

    public Integer getNunum() {
        return this.nunum;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getVcn() {
        return this.vcn;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public WebSocket start(WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        return this.newWebSocket(webSocketListener);
    }

    public void sendMessage(WebSocket webSocket, byte[] bytes, Integer status) {
        SimInterpRequest request = new SimInterpRequest();
        SimInterpRequest.Header header = new SimInterpRequest.Header(this.appId, status);
        request.setHeader(header);
        SimInterpRequest.Parameter parameter = new SimInterpRequest.Parameter(this);
        request.setParameter(parameter);
        SimInterpRequest.Payload payload = new SimInterpRequest.Payload();
        SimInterpRequest.Payload.Data data = new SimInterpRequest.Payload.Data();
        data.setSampleRate(this.sampleRate);
        data.setEncoding(this.encoding);
        data.setSeq(0);
        data.setStatus(status);
        if (bytes == null || bytes.length == 0) {
            data.setAudio("");
        } else {
            data.setAudio(Base64.getEncoder().encodeToString(bytes));
        }
        payload.setData(data);
        request.setPayload(payload);
        String json = StringUtils.gson.toJson((Object)request);
        logger.debug("\u540c\u58f0\u4f20\u8bd1\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)json);
        webSocket.send(json);
    }

    public void send(File file, WebSocketListener webSocketListener) throws FileNotFoundException, MalformedURLException, SignatureException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.send(fileInputStream, webSocketListener);
    }

    public void send(InputStream inputStream, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        if (inputStream == null) {
            return;
        }
        WebSocket socket = this.newWebSocket(webSocketListener);
        SimInterpSendTask sparkIatSendTask = new SimInterpSendTask();
        new AbstractNlpTask.Builder().inputStream(inputStream).client(this).webSocket(socket).build(sparkIatSendTask);
        this.executor.submit(sparkIatSendTask);
    }

    public void send(byte[] bytes, Closeable closeable, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        WebSocket socket = this.newWebSocket(webSocketListener);
        SimInterpSendTask sparkIatSendTask = new SimInterpSendTask();
        new AbstractNlpTask.Builder().bytes(bytes).client(this).webSocket(socket).closeable(closeable).build(sparkIatSendTask);
        this.executor.submit(sparkIatSendTask);
    }

    public static final class Builder
    extends WebsocketBuilder<Builder> {
        private String hostUrl = "https://ws-api.xf-yun.com/v1/private/simult_interpretation";
        private String language = "zh_cn";
        private int languageType = 1;
        private String domain = "ist_ed_open";
        private String accent = "mandarin";
        private Integer eos = 600000;
        private Integer vto = 15000;
        private Integer nunum = 1;
        private String from = "cn";
        private String to = "en";
        private String vcn = "x2_xiaoguo";
        private String encoding = "raw";
        private int sampleRate = 16000;
        private int channels = 1;
        private int bitDepth = 16;
        private ExecutorService executor;

        public SimInterpClient build() {
            return new SimInterpClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret) {
            super.signature(appId, apiKey, apiSecret);
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder languageType(int languageType) {
            this.languageType = languageType;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder accent(String accent) {
            this.accent = accent;
            return this;
        }

        public Builder eos(int eos) {
            this.eos = eos;
            return this;
        }

        public Builder vto(int vto) {
            this.vto = vto;
            return this;
        }

        public Builder nunum(int nunum) {
            this.nunum = nunum;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder vcn(String vcn) {
            this.vcn = vcn;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder channels(int channels) {
            this.channels = channels;
            return this;
        }

        public Builder bitDepth(int bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }
    }
}

