/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.LtpFunctionEnum;
import cn.xfyun.model.sign.Signature;
import java.io.IOException;
import java.util.Map;

public class LtpClient
extends HttpClient {
    private String type;
    private LtpFunctionEnum func;

    public String getType() {
        return this.type;
    }

    public String getFunc() {
        return this.func.getValue();
    }

    public LtpClient(Builder builder) {
        super((HttpBuilder)builder);
        this.func = builder.func;
        this.type = builder.type;
    }

    public String send(String text) throws IOException {
        String param = "{\"type\":\"" + this.type + "\"}";
        Map header = Signature.signHttpHeaderCheckSum((String)this.appId, (String)this.apiKey, (String)param);
        return this.sendPost(this.hostUrl + this.func.getValue(), FORM, header, "text=" + text);
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://ltpapi.xfyun.cn/v1/";
        private String type = "dependent";
        private LtpFunctionEnum func;

        public Builder(String appId, String apiKey, LtpFunctionEnum func) {
            super(HOST_URL, appId, apiKey, null);
            this.func = func;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder func(LtpFunctionEnum func) {
            this.func = func;
            return this;
        }

        public LtpClient build() {
            return new LtpClient(this);
        }
    }
}

