/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.ModeType;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.compliance.image.ImageCompParam;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.SignatureException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageComplianceClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(ImageComplianceClient.class);

    public ImageComplianceClient(Builder builder) {
        super((HttpBuilder)builder);
    }

    public String send(ImageCompParam param) throws IOException, SignatureException {
        this.paramCheck(param);
        Map parameters = Signature.getImageAuth((String)this.appId, (String)this.apiKey, (String)this.apiSecret, (ModeType)param.getModeType());
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.buildParam(param));
        return this.sendPost(this.hostUrl, null, body, parameters);
    }

    private String buildParam(ImageCompParam param) {
        JsonObject request = new JsonObject();
        request.addProperty("content", param.getContent());
        request.addProperty("biz_type", param.getBizType());
        logger.debug("\u56fe\u7247\u5408\u89c4\u8bf7\u6c42\u53c2\u6570: {}", (Object)request);
        return request.toString();
    }

    private void paramCheck(ImageCompParam param) {
        if (null == param) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNullOrEmpty((String)param.getContent())) {
            throw new BusinessException("content\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == param.getModeType()) {
            throw new BusinessException("modeType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://audit.iflyaisol.com/audit/v2/image";

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, appId, apiKey, apiSecret);
        }

        public ImageComplianceClient build() {
            return new ImageComplianceClient(this);
        }
    }
}

