/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.Audio;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.SignatureException;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioComplianceClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(AudioComplianceClient.class);
    private final String notifyUrl;
    private final String queryUrl;

    public AudioComplianceClient(Builder builder) {
        super((HttpBuilder)builder);
        this.notifyUrl = builder.notifyUrl;
        this.queryUrl = builder.queryUrl;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String send(List<Audio> audioList) throws IOException, SignatureException {
        return this.send(audioList, null);
    }

    public String send(List<Audio> audioList, String notifyUrl) throws SignatureException, IOException {
        this.paramCheck(audioList);
        Map parameters = Signature.getAuth((String)this.appId, (String)this.apiKey, (String)this.apiSecret);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.buildParam(audioList, notifyUrl));
        return this.sendPost(this.hostUrl, null, body, parameters);
    }

    public String query(String requestId) throws IOException, SignatureException {
        this.queryCheck(requestId);
        Map parameters = Signature.getAuth((String)this.appId, (String)this.apiKey, (String)this.apiSecret);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.buildQuery(requestId));
        return this.sendPost(this.queryUrl, null, body, parameters);
    }

    private void queryCheck(String requestId) {
        if (StringUtils.isNullOrEmpty((String)requestId)) {
            throw new BusinessException("requestId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void paramCheck(List<Audio> audioList) {
        if (null == audioList || audioList.isEmpty()) {
            throw new BusinessException("\u97f3\u9891\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildParam(List<Audio> audioList, String callBackUrl) {
        JsonObject param = new JsonObject();
        param.add("audio_list", StringUtils.gson.toJsonTree(audioList));
        param.addProperty("notify_url", StringUtils.isNullOrEmpty((String)callBackUrl) ? this.notifyUrl : callBackUrl);
        logger.debug("\u97f3\u9891\u5408\u89c4 sendAudio: {}", (Object)param);
        return param.toString();
    }

    private String buildQuery(String requestId) {
        JsonObject param = new JsonObject();
        param.addProperty("request_id", requestId);
        logger.debug("\u97f3\u9891\u5408\u89c4 sendQuery: {}", (Object)param);
        return param.toString();
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://audit.iflyaisol.com/audit/v2/audio";
        private String queryUrl = "https://audit.iflyaisol.com/audit/v2/query";
        private String notifyUrl;

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, appId, apiKey, apiSecret);
        }

        public AudioComplianceClient build() {
            return new AudioComplianceClient(this);
        }

        public Builder notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public Builder queryUrl(String queryUrl) {
            this.queryUrl = queryUrl;
            return this;
        }
    }
}

