/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.util;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpUtils.class);
    private static volatile OkHttpClient client;

    private static OkHttpClient createDefaultClient() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(100);
        dispatcher.setMaxRequestsPerHost(10);
        ConnectionPool connectionPool = new ConnectionPool(5, 5L, TimeUnit.MINUTES);
        return new OkHttpClient.Builder().dispatcher(dispatcher).connectionPool(connectionPool).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getDefaultClient() {
        if (client != null) return client;
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            if (client != null) return client;
            client = OkHttpUtils.createDefaultClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultClient(OkHttpClient defaultClient, boolean closeOld) {
        if (defaultClient == null) {
            throw new IllegalArgumentException("defaultClient must not be null");
        }
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            OkHttpClient oldClient = client;
            client = defaultClient;
            if (closeOld && oldClient != null && oldClient != defaultClient) {
                oldClient.connectionPool().evictAll();
                ExecutorService executorService = oldClient.dispatcher().executorService();
                executorService.shutdown();
                try {
                    if (!executorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                        executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                    logger.warn("Interrupted while closing old OkHttpClient dispatcher", (Throwable)e);
                }
                logger.debug("Old OkHttpClient instance has been closed and resources released.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Response get(String url, Map<String, String> headers, Map<String, String> params) throws IOException {
        return OkHttpUtils.request(url, "GET", null, headers, params);
    }

    public static Response post(String url, RequestBody body, Map<String, String> headers, Map<String, String> params) throws IOException {
        return OkHttpUtils.request(url, "POST", body, headers, params);
    }

    public static Response request(String url, String method, RequestBody body, Map<String, String> headers, Map<String, String> params) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null");
        }
        HttpUrl parsedUrl = HttpUrl.parse((String)url);
        if (parsedUrl == null) {
            throw new IllegalArgumentException("Invalid URL format: " + url);
        }
        HttpUrl.Builder urlBuilder = parsedUrl.newBuilder();
        if (params != null && !params.isEmpty()) {
            params.forEach((k, v) -> {
                if (k != null && v != null) {
                    urlBuilder.addQueryParameter(k, v);
                }
            });
        }
        Request.Builder reqBuilder = new Request.Builder().url(urlBuilder.build());
        switch (method.toUpperCase()) {
            case "GET": {
                if (body != null) {
                    logger.warn("GET request with body is not recommended.");
                }
                reqBuilder.get();
                break;
            }
            case "POST": {
                reqBuilder.post(body != null ? body : RequestBody.create(null, (byte[])new byte[0]));
                break;
            }
            case "PUT": {
                reqBuilder.put(body != null ? body : RequestBody.create(null, (byte[])new byte[0]));
                break;
            }
            case "DELETE": {
                reqBuilder.delete(body);
                break;
            }
            default: {
                reqBuilder.method(method.toUpperCase(), body);
            }
        }
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((k, v) -> {
                if (k != null && v != null) {
                    reqBuilder.addHeader(k, v);
                }
            });
        }
        Request request = reqBuilder.build();
        logger.debug("Executing {} request: {}", (Object)method.toUpperCase(), (Object)request.url());
        return OkHttpUtils.getDefaultClient().newCall(request).execute();
    }

    static {
        OkHttpUtils.getDefaultClient();
    }
}

