/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.util;

import cn.xfyun.model.sign.AbstractSignature;
import cn.xfyun.util.CryptTools;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SignatureException;
import okhttp3.HttpUrl;

public class AuthUtil {
    private static String algorithm = "hmac-sha256";

    public static String generateAuthorization(AbstractSignature signature) throws SignatureException {
        return AuthUtil.generateAuthorization(signature, algorithm);
    }

    public static String generateAuthorization(AbstractSignature signature, String algorithm) throws SignatureException {
        return String.format("api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", signature.getId(), algorithm, "host date request-line", signature.getSigna());
    }

    public static String generateTransAuthorization(AbstractSignature signature, String algorithm) throws SignatureException {
        return String.format("api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", signature.getId(), algorithm, "host date request-line digest", signature.getSigna());
    }

    public static String generateRequestUrl(AbstractSignature signature) throws MalformedURLException, SignatureException {
        URL url = new URL(signature.getUrl());
        String authorization = AuthUtil.generateAuthorization(signature);
        HttpUrl httpUrl = HttpUrl.parse((String)("https://" + url.getHost() + url.getPath())).newBuilder().addQueryParameter("authorization", CryptTools.base64Encode(authorization)).addQueryParameter("date", signature.getTs()).addQueryParameter("host", url.getHost()).build();
        return httpUrl.toString();
    }
}

