/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.sign;

import cn.xfyun.config.ModeType;
import cn.xfyun.util.CryptTools;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signature {
    private static final Logger logger = LoggerFactory.getLogger(Signature.class);

    public static String signHostDateAuthorization(String requestUrl, String requestMethod, String apiKey, String apiSecret) {
        URL url = null;
        String httpRequestUrl = requestUrl.replace("ws://", "http://").replace("wss://", "https://");
        try {
            url = new URL(httpRequestUrl);
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            String date = format.format(new Date());
            String host = url.getHost();
            StringBuilder builder = new StringBuilder().append("host: ").append(host).append("\n").append("date: ").append(date).append("\n").append(requestMethod).append(" ").append(url.getPath()).append(" HTTP/1.1");
            Charset charset = StandardCharsets.UTF_8;
            SecretKeySpec spec = new SecretKeySpec(apiSecret.getBytes(charset), "hmacsha256");
            Mac mac = Mac.getInstance("hmacsha256");
            mac.init(spec);
            byte[] hexDigits = mac.doFinal(builder.toString().getBytes(charset));
            String sha = Base64.getEncoder().encodeToString(hexDigits);
            String authorization = String.format("api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", apiKey, "hmac-sha256", "host date request-line", sha);
            String authBase = Base64.getEncoder().encodeToString(authorization.getBytes(charset));
            return String.format("%s?authorization=%s&host=%s&date=%s", requestUrl, URLEncoder.encode(authBase), URLEncoder.encode(host), URLEncoder.encode(date));
        }
        catch (Exception e) {
            throw new RuntimeException("assemble requestUrl error:" + e.getMessage());
        }
    }

    public static Map<String, String> signHttpHeaderDigest(String requestUrl, String requestMethod, String apiKey, String apiSecret, String body) throws Exception {
        HashMap<String, String> header = new HashMap<String, String>(6);
        URL url = new URL(requestUrl);
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = format.format(new Date());
        String digestBase64 = "SHA-256=" + Signature.signBody(body);
        StringBuilder builder = new StringBuilder("host: ").append(url.getHost()).append("\n").append("date: ").append(date).append("\n").append(requestMethod + " ").append(url.getPath()).append(" HTTP/1.1").append("\n").append("digest: ").append(digestBase64);
        String sha = Signature.hmacsign(builder.toString(), apiSecret);
        String authorization = String.format("api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", apiKey, "hmac-sha256", "host date request-line digest", sha);
        header.put("Authorization", authorization);
        header.put("Content-Type", "application/json");
        header.put("Accept", "application/json,version=1.0");
        header.put("Host", url.getHost());
        header.put("Date", date);
        header.put("Digest", digestBase64);
        return header;
    }

    private static String signBody(String body) {
        String encodestr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(body.getBytes("UTF-8"));
            encodestr = Base64.getEncoder().encodeToString(messageDigest.digest());
        }
        catch (Exception e) {
            logger.error("\u5bf9body\u8fdb\u884cSHA-256\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
        }
        return encodestr;
    }

    private static String hmacsign(String signature, String apiSecret) throws Exception {
        Charset charset = Charset.forName("UTF-8");
        Mac mac = Mac.getInstance("hmacsha256");
        SecretKeySpec spec = new SecretKeySpec(apiSecret.getBytes(charset), "hmacsha256");
        mac.init(spec);
        byte[] hexDigits = mac.doFinal(signature.getBytes(charset));
        return Base64.getEncoder().encodeToString(hexDigits);
    }

    public static Map<String, String> signHttpHeaderCheckSum(String appId, String apiKey, String param) throws UnsupportedEncodingException {
        String curTime = String.valueOf(System.currentTimeMillis() / 1000L);
        String paramBase64 = Base64.getEncoder().encodeToString(param.getBytes("UTF-8"));
        String checkSum = DigestUtils.md5Hex((String)(apiKey + curTime + paramBase64));
        HashMap<String, String> header = new HashMap<String, String>(6);
        header.put("X-Param", paramBase64);
        header.put("X-CurTime", curTime);
        header.put("X-CheckSum", checkSum);
        header.put("X-Appid", appId);
        return header;
    }

    public static String rtasrSignature(String url, String appId, String key) {
        url = url.replace("ws://", "http://").replace("wss://", "https://");
        String ts = String.valueOf(System.currentTimeMillis() / 1000L);
        try {
            String signature = CryptTools.hmacEncrypt("HmacSHA1", CryptTools.md5Encrypt(appId + ts), key);
            return url + "?appid=" + appId + "&ts=" + ts + "&signa=" + URLEncoder.encode(signature, "UTF-8");
        }
        catch (Exception e) {
            logger.error("rtasrSignature error", (Throwable)e);
            return "";
        }
    }

    public static String generateSignature(String appId, Long timestamp, String apiSecret) {
        try {
            return CryptTools.hmacEncrypt("HmacSHA1", CryptTools.md5Encrypt(appId + timestamp), apiSecret);
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getAuth(String appid, String APIKey, String APISecret) throws SignatureException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String utc = format.format(new Date());
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("appId", appid);
        urlParams.put("accessKeyId", APIKey);
        urlParams.put("utc", utc);
        urlParams.put("uuid", UUID.randomUUID().toString());
        String signature = Signature.signature(APISecret, urlParams);
        urlParams.put("signature", signature);
        return urlParams;
    }

    private static String signature(String secret, Map<String, String> queryParam) throws SignatureException {
        try {
            TreeMap<String, String> treeMap = new TreeMap<String, String>(queryParam);
            treeMap.remove("signature");
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : treeMap.entrySet()) {
                String value = entry.getValue();
                if (value == null || value.isEmpty()) continue;
                String encode = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
                builder.append(entry.getKey()).append("=").append(encode).append("&");
            }
            if (builder.length() > 0) {
                builder.deleteCharAt(builder.length() - 1);
            }
            String baseString = builder.toString();
            Mac mac = Mac.getInstance("HmacSHA1");
            SecretKeySpec keySpec = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8.name());
            mac.init(keySpec);
            byte[] signBytes = mac.doFinal(baseString.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signBytes);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("InvalidKeyException:" + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException("NoSuchAlgorithmException:" + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException("UnsupportedEncodingException:" + e.getMessage());
        }
    }

    public static Map<String, String> getImageAuth(String appid, String APIKey, String APISecret, ModeType modeType) throws SignatureException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String utc = format.format(new Date());
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("appId", appid);
        urlParams.put("accessKeyId", APIKey);
        urlParams.put("modeType", modeType.getValue());
        urlParams.put("utc", utc);
        urlParams.put("uuid", UUID.randomUUID().toString());
        String signature = Signature.signature(APISecret, urlParams);
        urlParams.put("signature", signature);
        return urlParams;
    }
}

