/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.base.websocket;

import cn.xfyun.base.websocket.AbstractClient;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.internal.Util;

public abstract class WebsocketBuilder<T> {
    private String appId;
    private String apiKey;
    private String apiSecret;
    private boolean retryOnConnectionFailure = true;
    private int callTimeout = 0;
    private int connectTimeout = 30000;
    private int readTimeout = 30000;
    private int writeTimeout = 30000;
    private int pingInterval = 0;
    private OkHttpClient httpClient;
    private Proxy proxy;

    protected T signature(String appId, String apiKey, String apiSecret) {
        this.appId = appId;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        return (T)this;
    }

    public T httpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return (T)this;
    }

    public T callTimeout(long timeout, TimeUnit unit) {
        this.callTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
        return (T)this;
    }

    public T connectTimeout(long timeout, TimeUnit unit) {
        this.connectTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
        return (T)this;
    }

    public T readTimeout(long timeout, TimeUnit unit) {
        this.readTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
        return (T)this;
    }

    public T writeTimeout(long timeout, TimeUnit unit) {
        this.writeTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
        return (T)this;
    }

    public T pingInterval(long interval, TimeUnit unit) {
        this.pingInterval = Util.checkDuration((String)"interval", (long)interval, (TimeUnit)unit);
        return (T)this;
    }

    public T retryOnConnectionFailure(boolean retryOnConnectionFailure) {
        this.retryOnConnectionFailure = retryOnConnectionFailure;
        return (T)this;
    }

    public T proxy(Proxy proxy) {
        this.proxy = proxy;
        return (T)this;
    }

    public T appId(String appId) {
        this.appId = appId;
        return (T)this;
    }

    public T apiKey(String apiKey) {
        this.apiKey = apiKey;
        return (T)this;
    }

    public T apiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
        return (T)this;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public boolean getRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public int getCallTimeout() {
        return this.callTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public abstract AbstractClient build();
}

