/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.base.http;

import cn.xfyun.base.http.HttpClient;
import java.net.Proxy;
import okhttp3.OkHttpClient;

public abstract class HttpBuilder<T> {
    private String hostUrl;
    private String appId;
    private String apiKey;
    private String apiSecret;
    private boolean retryOnConnectionFailure = false;
    private int callTimeout = 0;
    private int connectTimeout = 10;
    private int readTimeout = 10;
    private int writeTimeout = 10;
    private OkHttpClient httpClient;
    private Proxy proxy;

    public HttpBuilder(String hostUrl, String appId, String apiKey, String apiSecret) {
        this.hostUrl = hostUrl;
        this.appId = appId;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    public T httpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return (T)this;
    }

    public T retryOnConnectionFailure(boolean retryOnConnectionFailure) {
        this.retryOnConnectionFailure = retryOnConnectionFailure;
        return (T)this;
    }

    public T callTimeout(int callTimeout) {
        this.callTimeout = callTimeout;
        return (T)this;
    }

    public T connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return (T)this;
    }

    public T readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return (T)this;
    }

    public T writeTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
        return (T)this;
    }

    public T proxy(Proxy proxy) {
        this.proxy = proxy;
        return (T)this;
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    public T hostUrl(String hostUrl) {
        this.hostUrl = hostUrl;
        return (T)this;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public T appId(String appId) {
        this.appId = appId;
        return (T)this;
    }

    public T apiKey(String apiKey) {
        this.apiKey = apiKey;
        return (T)this;
    }

    public T apiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
        return (T)this;
    }

    public boolean getRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public int getCallTimeout() {
        return this.callTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public abstract HttpClient build();
}

