/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest.otp;

import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;

public class HOTP {
    private static final int[] MOD_DIVISORS = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};
    public static final int DEFAULT_PASSWORD_LENGTH = 6;
    public static final HmacAlgorithm HOTP_HMAC_ALGORITHM = HmacAlgorithm.HmacSHA1;
    private final HMac mac;
    private final int passwordLength;
    private final int modDivisor;
    private final byte[] buffer;

    public HOTP(byte[] key) {
        this(6, key);
    }

    public HOTP(int passwordLength, byte[] key) {
        this(passwordLength, HOTP_HMAC_ALGORITHM, key);
    }

    public HOTP(int passwordLength, HmacAlgorithm algorithm, byte[] key) {
        this.mac = new HMac(algorithm, key);
        this.modDivisor = MOD_DIVISORS[passwordLength];
        this.passwordLength = passwordLength;
        this.buffer = new byte[this.mac.getMacLength()];
    }

    public synchronized int generate(long counter) {
        this.buffer[0] = (byte)((counter & 0xFF00000000000000L) >>> 56);
        this.buffer[1] = (byte)((counter & 0xFF000000000000L) >>> 48);
        this.buffer[2] = (byte)((counter & 0xFF0000000000L) >>> 40);
        this.buffer[3] = (byte)((counter & 0xFF00000000L) >>> 32);
        this.buffer[4] = (byte)((counter & 0xFF000000L) >>> 24);
        this.buffer[5] = (byte)((counter & 0xFF0000L) >>> 16);
        this.buffer[6] = (byte)((counter & 0xFF00L) >>> 8);
        this.buffer[7] = (byte)(counter & 0xFFL);
        byte[] digest = this.mac.digest(this.buffer);
        return this.truncate(digest);
    }

    private int truncate(byte[] digest) {
        int offset = digest[digest.length - 1] & 0xF;
        return ((digest[offset] & 0x7F) << 24 | (digest[offset + 1] & 0xFF) << 16 | (digest[offset + 2] & 0xFF) << 8 | digest[offset + 3] & 0xFF) % this.modDivisor;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public String getAlgorithm() {
        return this.mac.getAlgorithm();
    }
}

